/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.api;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.kualigan.maven.plugins.api.OverlayHelper;

@Component(role=OverlayHelper.class, hint="default")
public class DefaultOverlayHelper
implements OverlayHelper {
    public static final String ROLE_HINT = "default";
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";
    private static final String ALTERNATE_POM_FILE = "f";
    @Requirement
    private Archetype archetype;
    @Requirement
    private Prompter prompter;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement(role=ArtifactRepositoryLayout.class, hint="default")
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    private AbstractMojo caller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateArchetype(File mavenHome, final String archetypeGroupId, final String archetypeArtifactId, final String archetypeVersion, final String groupId, final String artifactId, final String version, final String prototypeGroupId, final String prototypeArtifactId, final String prototypeVersion) throws MojoExecutionException {
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        String additionalArguments = "";
        InvocationRequest req = new DefaultInvocationRequest().setInteractive(false).setProperties(new Properties(){
            {
                this.setProperty("archetypeGroupId", archetypeGroupId);
                this.setProperty("archetypeArtifactId", archetypeArtifactId);
                this.setProperty("archetypeVersion", archetypeVersion);
                this.setProperty("groupId", groupId);
                this.setProperty("artifactId", artifactId);
                this.setProperty("version", version);
                this.setProperty("kfsPrototypeGroupId", prototypeGroupId);
                this.setProperty("kfsPrototypeArtifactId", prototypeArtifactId);
                this.setProperty("kfsPrototypeVersion", prototypeVersion);
            }
        });
        this.setupRequest(req, "");
        req.setGoals((List)new ArrayList<String>(){
            {
                this.add("archetype:generate");
            }
        });
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MojoExecutionException("Error executing Maven.", (Exception)invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'");
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven build.", (Exception)((Object)e));
        }
    }

    private void setupRequest(InvocationRequest req, String additionalArguments) throws MojoExecutionException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)additionalArguments);
            CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                req.setDebug(false);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P')) {
                String[] profiles = cli.getOptionValues('P');
                ArrayList<String> activatedProfiles = new ArrayList<String>();
                ArrayList<String> deactivatedProfiles = new ArrayList<String>();
                if (profiles != null) {
                    for (int i = 0; i < profiles.length; ++i) {
                        StringTokenizer profileTokens = new StringTokenizer(profiles[i], ",");
                        while (profileTokens.hasMoreTokens()) {
                            String profileAction = profileTokens.nextToken().trim();
                            if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                                deactivatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            if (profileAction.startsWith("+")) {
                                activatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            activatedProfiles.add(profileAction);
                        }
                    }
                }
                if (!deactivatedProfiles.isEmpty()) {
                    this.getCaller().getLog().warn((CharSequence)("Explicit profile deactivation is not yet supported. The following profiles will NOT be deactivated: " + StringUtils.join(deactivatedProfiles.iterator(), (String)", ")));
                }
                if (!activatedProfiles.isEmpty()) {
                    req.setProfiles(activatedProfiles);
                }
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getCaller().getLog().warn((CharSequence)"Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getCaller().getLog().warn((CharSequence)"Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
            if (cli.hasOption(ALTERNATE_POM_FILE)) {
                if (req.getPomFileName() != null) {
                    this.getCaller().getLog().info((CharSequence)"pomFileName is already set, ignoring the -f argument");
                } else {
                    req.setPomFileName(cli.getOptionValue(ALTERNATE_POM_FILE));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    @Override
    public void setCaller(AbstractMojo caller) {
        this.caller = caller;
    }

    @Override
    public AbstractMojo getCaller() {
        return this.caller;
    }
}

