/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.api;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.kualigan.maven.plugins.api.PrototypeHelper;

@Component(role=PrototypeHelper.class, hint="default")
public class DefaultPrototypeHelper
implements PrototypeHelper {
    public static final String ROLE_HINT = "default";
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";
    private static final String ALTERNATE_POM_FILE = "f";
    @Requirement
    protected Archetype archetype;
    @Requirement
    protected Prompter prompter;
    @Requirement
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement(role=ArtifactRepositoryLayout.class, hint="default")
    protected ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    @Requirement
    protected ArchiverManager archiverManager;
    private AbstractMojo caller;

    protected void logUnpack(File file, File location, String includes, String excludes) {
        if (!this.getCaller().getLog().isInfoEnabled()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        this.getCaller().getLog().info((CharSequence)msg.toString());
    }

    protected int executeCommandLine(String ... args) throws ExecuteException, IOException {
        DefaultExecutor exec = new DefaultExecutor();
        HashMap<Object, Object> enviro = new HashMap<Object, Object>();
        try {
            Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
            enviro.putAll(systemEnvVars);
        }
        catch (IOException x) {
            this.getCaller().getLog().error((CharSequence)"Could not assign default system enviroment variables.", (Throwable)x);
        }
        File workingDirectory = new File(System.getProperty("java.io.tmpdir"));
        CommandLine commandLine = new CommandLine(args[0]);
        for (int i = 1; i < args.length; ++i) {
            commandLine.addArgument(args[i]);
        }
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        exec.setWorkingDirectory(workingDirectory);
        return exec.execute(commandLine, enviro);
    }

    public File repack(File file, String artifactId) throws MojoExecutionException {
        File workingDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + artifactId + "-repack");
        File warDirectory = new File(workingDirectory, "war");
        File repackDirectory = new File(workingDirectory, artifactId);
        File classesDirectory = new File(warDirectory, "WEB-INF/classes");
        File retval = new File(workingDirectory, artifactId + ".jar");
        try {
            workingDirectory.mkdirs();
            workingDirectory.mkdir();
            workingDirectory.deleteOnExit();
            warDirectory.mkdir();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create working directory for repackaging", e);
        }
        this.unpack(file, warDirectory, "**/classes/**", null);
        try {
            FileUtils.copyDirectoryStructure((File)classesDirectory, (File)repackDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to copy files into the repack directory");
        }
        try {
            this.pack(retval, repackDirectory, "**/**", null);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Was unable to create the jar", e);
        }
        return retval;
    }

    protected void unpack(File file, File location, String includes, String excludes) throws MojoExecutionException {
        try {
            this.logUnpack(file, location, includes, excludes);
            location.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    protected void pack(File file, final File location, final String includes, final String excludes) throws MojoExecutionException {
        try {
            Archiver archiver = this.archiverManager.getArchiver(file);
            archiver.addFileSet((FileSet)new DefaultFileSet(){
                {
                    this.setDirectory(location);
                    if (includes != null) {
                        this.setIncludes(includes.split(","));
                    }
                    if (excludes != null) {
                        this.setExcludes(excludes.split(","));
                    }
                }
            });
            archiver.setDestFile(file);
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error packing directory: " + location + " to: " + file + "\r\n" + e.toString(), e);
        }
    }

    private void setupRequest(InvocationRequest req, String additionalArguments) throws MojoExecutionException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)additionalArguments);
            org.apache.commons.cli.CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                req.setDebug(false);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P')) {
                String[] profiles = cli.getOptionValues('P');
                ArrayList<String> activatedProfiles = new ArrayList<String>();
                ArrayList<String> deactivatedProfiles = new ArrayList<String>();
                if (profiles != null) {
                    for (int i = 0; i < profiles.length; ++i) {
                        StringTokenizer profileTokens = new StringTokenizer(profiles[i], ",");
                        while (profileTokens.hasMoreTokens()) {
                            String profileAction = profileTokens.nextToken().trim();
                            if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                                deactivatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            if (profileAction.startsWith("+")) {
                                activatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            activatedProfiles.add(profileAction);
                        }
                    }
                }
                if (!deactivatedProfiles.isEmpty()) {
                    this.getCaller().getLog().warn((CharSequence)("Explicit profile deactivation is not yet supported. The following profiles will NOT be deactivated: " + StringUtils.join(deactivatedProfiles.iterator(), (String)", ")));
                }
                if (!activatedProfiles.isEmpty()) {
                    req.setProfiles(activatedProfiles);
                }
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getCaller().getLog().warn((CharSequence)"Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getCaller().getLog().warn((CharSequence)"Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
            if (cli.hasOption(ALTERNATE_POM_FILE)) {
                if (req.getPomFileName() != null) {
                    this.getCaller().getLog().info((CharSequence)"pomFileName is already set, ignoring the -f argument");
                } else {
                    req.setPomFileName(cli.getOptionValue(ALTERNATE_POM_FILE));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installArtifact(final File artifact, final File sources, File mavenHome, String groupId, String artifactId, String version, final String repositoryId) throws MojoExecutionException {
        this.extractTempPom();
        this.filterTempPom(groupId, artifactId, artifact.getName().endsWith("jar") ? "jar" : "war", version);
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        String additionalArguments = "";
        this.getCaller().getLog().debug((CharSequence)"Setting up properties for installing the artifact");
        InvocationRequest req = new DefaultInvocationRequest().setInteractive(false).setProperties(new Properties(){
            {
                this.setProperty("pomFile", DefaultPrototypeHelper.this.getTempPomPath());
                if (repositoryId != null) {
                    this.setProperty("repositoryId", repositoryId);
                }
                if (sources != null) {
                    try {
                        this.setProperty("sources", DefaultPrototypeHelper.this.zipSourcesIfRequired(sources).getCanonicalPath());
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Cannot get path for the sources file ", e);
                    }
                }
                try {
                    this.setProperty("file", artifact.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Cannot get path for the war file ", e);
                }
                this.setProperty("updateReleaseInfo", "true");
            }
        });
        this.getCaller().getLog().debug((CharSequence)"Properties used for installArtifact are:");
        try {
            req.getProperties().list(System.out);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setupRequest(req, "");
        if (repositoryId == null) {
            req.setGoals((List)new ArrayList<String>(){
                {
                    this.add("install:install-file");
                }
            });
        } else {
            req.setGoals((List)new ArrayList<String>(){
                {
                    this.add("deploy:deploy-file");
                }
            });
        }
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MojoExecutionException("Error executing Maven.", (Exception)invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'");
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven build.", (Exception)((Object)e));
        }
    }

    public void filterTempPom(String groupId, String artifactId, String packaging, String version) throws MojoExecutionException {
        this.getCaller().getLog().info((CharSequence)"Filtering the Temp POM");
        FileWriter writer = null;
        FileReader reader = null;
        try {
            VelocityContext context = new VelocityContext();
            context.put("groupId", (Object)groupId);
            context.put("artifactId", (Object)artifactId);
            context.put("packaging", (Object)packaging);
            context.put("version", (Object)version);
            writer = new FileWriter(System.getProperty("java.io.tmpdir") + File.separator + "pom.xml");
            reader = new FileReader(new File(System.getProperty("java.io.tmpdir") + File.separator + "prototype-pom.xml"));
            Velocity.init();
            Velocity.evaluate((Context)context, (Writer)writer, (String)"pom-prototype", (Reader)reader);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Error trying to filter the pom ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
    }

    protected String getTempPomPath() {
        return System.getProperty("java.io.tmpdir") + File.separator + "pom.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractTempPom() throws MojoExecutionException {
        this.getCaller().getLog().info((CharSequence)"Extracting the Temp Pom");
        InputStream pom_is = this.getClass().getClassLoader().getResourceAsStream("prototype-resources/pom.xml");
        byte[] fileBytes = null;
        try {
            DataInputStream dis = new DataInputStream(pom_is);
            fileBytes = new byte[dis.available()];
            dis.readFully(fileBytes);
            dis.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Wasn't able to read in the prototype pom", e);
        }
        finally {
            try {
                pom_is.close();
            }
            catch (Exception e) {}
        }
        try {
            FileOutputStream fos = new FileOutputStream(System.getProperty("java.io.tmpdir") + File.separator + "prototype-pom.xml");
            try {
                fos.write(fileBytes);
            }
            finally {
                fos.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not write temporary pom file", e);
        }
    }

    protected File zipSourcesIfRequired(File sources) {
        if (sources.isFile()) {
            return sources;
        }
        File zipFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "sources.zip");
        zipFile.deleteOnExit();
        ZipArchiver zipArchiver = new ZipArchiver();
        zipArchiver.addDirectory(sources, new String[]{"**/*"}, new String[0]);
        zipArchiver.setDestFile(zipFile);
        try {
            zipArchiver.createArchive();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to zip source directory", e);
        }
        return zipFile;
    }

    public void setCaller(AbstractMojo caller) {
        this.caller = caller;
    }

    public AbstractMojo getCaller() {
        return this.caller;
    }
}

