/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.liquibase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.util.xml.DefaultXmlWriter;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class LiquibaseTestMojo
extends AbstractLiquibaseChangeLogMojo {
    public static final String DEFAULT_CHANGELOG_PATH = "src/main/changelogs";
    public static final String DEFAULT_UPDATE_FILE = "target/changelogs/update.xml";
    public static final String DEFAULT_UPDATE_PATH = "target/changelogs/update";
    public static final String DEFAULT_LBPROP_PATH = "target/test-classes/liquibase/";
    public static final String TEST_ROLLBACK_TAG = "test";
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    @Parameter(property="liquibase.driver", required=true)
    protected String driver;
    @Parameter(property="liquibase.url", required=true)
    protected String url;
    @Component(role=WagonManager.class)
    protected WagonManager wagonManager;
    @Parameter(property="liquibase.server", required=true)
    private String server;
    @Parameter(property="liquibase.username", required=true)
    protected String username;
    @Parameter(property="liquibase.password", required=true)
    protected String password;
    @Parameter(property="liquibase.defaultSchemaName")
    protected String defaultSchemaName;
    @Parameter(property="liquibase.databaseClass", required=true)
    protected String databaseClass;
    protected boolean promptOnNonLocalDatabase;
    protected boolean includeArtifact;
    protected boolean includeTestOutputDirectory;
    protected boolean verbose;
    protected String logging;
    protected String propertyFile;
    protected boolean propertyFileWillOverride;
    protected boolean clearCheckSums;
    protected Properties systemProperties;
    protected String changeLogFile;
    protected File changeLogSavePath;
    @Parameter(property="lb.updatePath", defaultValue="${project.basedir}/src/main/scripts/changelogs")
    protected File updatePath;
    @Parameter(property="liquibase.rollbackTag")
    protected String rollbackTag;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    protected String contexts;

    protected File getBasedir() {
        return this.project.getBasedir();
    }

    protected void doFieldHack() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field parentField = this.getDeclaredField(((Object)((Object)this)).getClass().getSuperclass(), field.getName());
                if (parentField == null) continue;
                this.getLog().debug((CharSequence)("Setting " + field.getName() + " in " + parentField.getDeclaringClass().getName() + " to " + field.get((Object)this)));
                parentField.set((Object)this, field.get((Object)this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected File[] getLiquibasePropertiesFiles() throws MojoExecutionException {
        try {
            File[] retval = new File(this.getBasedir(), DEFAULT_LBPROP_PATH).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            if (retval == null) {
                throw new NullPointerException();
            }
            return retval;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to get liquibase properties files ");
            return new File[0];
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] propertyFiles;
        this.changeLogFile = DEFAULT_UPDATE_FILE;
        try {
            Method meth = AbstractLiquibaseMojo.class.getDeclaredMethod("processSystemProperties", new Class[0]);
            meth.setAccessible(true);
            meth.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((AbstractLiquibaseChangeLogMojo)this).project = this.project;
        ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
        for (File props : propertyFiles = this.getLiquibasePropertiesFiles()) {
            try {
                this.propertyFile = props.getCanonicalPath();
                this.doFieldHack();
                this.configureFieldsAndValues(this.getFileOpener(artifactClassLoader));
                this.doFieldHack();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            super.execute();
        }
    }

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        this.getLog().info((CharSequence)"Tagging the database");
        this.rollbackTag = TEST_ROLLBACK_TAG;
        liquibase.tag(this.rollbackTag);
        File realChangeLogFile = new File(this.changeLogFile);
        if (!realChangeLogFile.exists()) {
            try {
                Collection<File> changelogs = this.scanForChangelogs(this.changeLogSavePath);
                this.generateUpdateLog(realChangeLogFile, changelogs);
            }
            catch (Exception e) {
                throw new LiquibaseException((Throwable)e);
            }
        }
        this.getLog().info((CharSequence)"Doing update");
        liquibase.update(this.contexts);
        this.getLog().info((CharSequence)"Doing rollback");
        liquibase.rollback(this.rollbackTag, this.contexts);
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = this.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this " + "task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    protected Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field f;
        this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
        try {
            f = clazz.getDeclaredField(fieldName);
            if (f != null) {
                return f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
            try {
                f = clazz.getDeclaredField(fieldName);
                if (f == null) continue;
                return f;
            }
            catch (Exception exception) {
            }
        }
        throw new NoSuchFieldException("The field '" + fieldName + "' could not be " + "found in the class of any of its parent " + "classes.");
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else {
            field.set((Object)this, value);
        }
    }

    protected Collection<File> scanForChangelogs(File searchPath) {
        ArrayList<File> retval = new ArrayList<File>();
        if (searchPath.getName().endsWith("update")) {
            return Arrays.asList(searchPath.listFiles());
        }
        if (searchPath.isDirectory()) {
            for (File file : searchPath.listFiles()) {
                if (!file.isDirectory()) continue;
                retval.addAll(this.scanForChangelogs(file));
            }
        }
        return retval;
    }

    protected void generateUpdateLog(File changeLogFile, Collection<File> changelogs) throws FileNotFoundException, IOException {
        DocumentBuilder documentBuilder;
        changeLogFile.getParentFile().mkdirs();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        documentBuilder.setEntityResolver((EntityResolver)new LiquibaseEntityResolver());
        Document doc = documentBuilder.newDocument();
        Element changeLogElement = doc.createElementNS(XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace(), "databaseChangeLog");
        changeLogElement.setAttribute("xmlns", XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace());
        changeLogElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        changeLogElement.setAttribute("xsi:schemaLocation", "http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + XMLChangeLogSAXParser.getSchemaVersion() + ".xsd");
        doc.appendChild(changeLogElement);
        for (File changelog : changelogs) {
            doc.getDocumentElement().appendChild(this.includeNode(doc, changelog));
        }
        new DefaultXmlWriter().write(doc, (OutputStream)new FileOutputStream(changeLogFile));
    }

    protected Element includeNode(Document parentChangeLog, File changelog) throws IOException {
        Element retval = parentChangeLog.createElementNS(XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace(), "include");
        retval.setAttribute("file", changelog.getCanonicalPath());
        return retval;
    }
}

