/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.liquibase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.util.xml.DefaultXmlWriter;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.AbstractLiquibaseUpdateMojo;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class MigrateMojo
extends AbstractLiquibaseUpdateMojo {
    public static final String DEFAULT_CHANGELOG_PATH = "src/main/scripts/changelogs";
    public static final String DEFAULT_UPDATE_FILE = "target/changelogs/update.xml";
    public static final String DEFAULT_UPDATE_PATH = "target/changelogs/update";
    public static final String DEFAULT_LBPROP_PATH = "target/test-classes/liquibase/";
    public static final String TEST_ROLLBACK_TAG = "test";
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    protected String driver;
    protected String url;
    protected WagonManager wagonManager;
    private String server;
    protected String username;
    protected String password;
    protected boolean emptyPassword;
    protected String defaultSchemaName;
    protected String databaseClass;
    protected boolean promptOnNonLocalDatabase;
    protected boolean includeArtifact;
    protected boolean includeTestOutputDirectory;
    protected boolean verbose;
    protected String logging;
    protected String propertyFile;
    protected boolean propertyFileWillOverride;
    protected boolean clearCheckSums;
    protected Properties systemProperties;
    protected String svnUsername;
    protected String svnPassword;
    protected String svnServer;
    protected File changeLogSavePath;
    protected URL changeLogTagUrl;
    protected File updatePath;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    protected boolean dropFirst;

    protected File getBasedir() {
        return this.project.getBasedir();
    }

    protected SVNURL getChangeLogTagUrl() throws SVNException {
        if (this.changeLogTagUrl == null) {
            return this.getProjectSvnUrlFrom(this.getBasedir()).appendPath("tags", true);
        }
        return SVNURL.parseURIEncoded((String)this.changeLogTagUrl.toString());
    }

    protected void doFieldHack() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field parentField = this.getDeclaredField(((Object)((Object)this)).getClass().getSuperclass(), field.getName());
                if (parentField == null) continue;
                this.getLog().debug((CharSequence)("Setting " + field.getName() + " in " + parentField.getDeclaringClass().getName() + " to " + field.get((Object)this)));
                parentField.set((Object)this, field.get((Object)this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected File[] getLiquibasePropertiesFiles() throws MojoExecutionException {
        try {
            File[] retval = new File(this.getBasedir(), DEFAULT_LBPROP_PATH).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            if (retval == null) {
                throw new NullPointerException();
            }
            return retval;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to get liquibase properties files ");
            return new File[0];
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo info;
        File[] propertyFiles;
        this.doFieldHack();
        try {
            Method meth = AbstractLiquibaseMojo.class.getDeclaredMethod("processSystemProperties", new Class[0]);
            meth.setAccessible(true);
            meth.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
        for (File props : propertyFiles = this.getLiquibasePropertiesFiles()) {
            try {
                this.propertyFile = props.getCanonicalPath();
                this.doFieldHack();
                this.configureFieldsAndValues(this.getFileOpener(artifactClassLoader));
                this.doFieldHack();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (this.svnServer != null && (info = this.wagonManager.getAuthenticationInfo(this.svnServer)) != null) {
            this.svnUsername = info.getUserName();
            this.svnPassword = info.getPassword();
        }
        DAVRepositoryFactory.setup();
        if (!this.isUpdateRequired()) {
            return;
        }
        boolean shouldLocalUpdate = false;
        try {
            Collection<SVNURL> svnurls = this.getTagUrls();
            shouldLocalUpdate = svnurls == null || svnurls.size() < 1;
            for (SVNURL tag : svnurls) {
                String tagBasePath = this.getLocalTagPath(tag);
                File tagPath = new File(tagBasePath, "update");
                tagPath.mkdirs();
                SVNURL changeLogUrl = tag.appendPath("src/main/scripts/changelogs/update", true);
                SVNClientManager.newInstance().getUpdateClient().doExport(changeLogUrl, tagPath, SVNRevision.HEAD, SVNRevision.HEAD, null, true, SVNDepth.INFINITY);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception when exporting changelogs from previous revisions", e);
        }
        this.changeLogFile = new File(this.changeLogSavePath, "update.xml").getPath();
        File changeLogSearchPath = this.changeLogSavePath;
        if (shouldLocalUpdate) {
            this.changeLogSavePath = new File(this.changeLogSavePath, "update");
        }
        Collection<File> changelogs = this.scanForChangelogs(changeLogSearchPath);
        try {
            this.generateUpdateLog(new File(this.changeLogFile), changelogs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate changelog file " + this.changeLogFile, e);
        }
        super.execute();
    }

    protected String getLocalTagPath(SVNURL tag) {
        String tagPath = tag.getPath();
        return this.changeLogSavePath + File.separator + tagPath.substring(tagPath.lastIndexOf("/") + 1);
    }

    protected boolean isUpdateRequired() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Comparing " + this.getCurrentRevision() + " to " + this.getLocalRevision()));
            String[] updates = new File(DEFAULT_CHANGELOG_PATH + File.separator + "update").list();
            boolean hasUpdates = updates != null && updates.length > 0;
            return this.getCurrentRevision() > this.getLocalRevision() || hasUpdates;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not compare local and remote revisions ", e);
        }
    }

    protected SVNURL getProjectSvnUrlFrom(File path) throws SVNException {
        SVNURL retval = this.getWCClient().doInfo(this.getBasedir(), SVNRevision.HEAD).getURL();
        String removeToken = null;
        if (retval.getPath().indexOf("/branches") > -1) {
            removeToken = "/branches";
        } else if (retval.getPath().indexOf("/tags") > -1) {
            removeToken = "/tags";
        } else if (retval.getPath().indexOf("/trunk") > -1) {
            removeToken = "/trunk";
        }
        this.getLog().debug((CharSequence)("Checking path " + retval.getPath() + " for token " + removeToken));
        while (retval.getPath().indexOf(removeToken) > -1) {
            retval = retval.removePathTail();
        }
        return retval;
    }

    protected Long getCurrentRevision() throws SVNException {
        return this.getWCClient().doInfo(this.getBasedir(), SVNRevision.HEAD).getCommittedRevision().getNumber();
    }

    protected Long getLocalRevision() throws SVNException {
        return this.getWCClient().doInfo(this.getBasedir(), SVNRevision.WORKING).getRevision().getNumber();
    }

    protected Long getTagRevision(String tag) throws SVNException {
        return this.getWCClient().doInfo(this.getChangeLogTagUrl(), SVNRevision.WORKING, SVNRevision.WORKING).getRevision().getNumber();
    }

    protected Collection<SVNURL> getTagUrls() throws SVNException {
        final ArrayList<SVNURL> retval = new ArrayList<SVNURL>();
        this.getLog().debug((CharSequence)("Looking up tags in " + this.getChangeLogTagUrl().toString()));
        this.clientManager().getLogClient().doList(this.getChangeLogTagUrl(), SVNRevision.HEAD, SVNRevision.HEAD, false, false, new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                if (dirEntry.getRevision() >= MigrateMojo.this.getLocalRevision() && dirEntry.getPath().trim().length() > 0) {
                    MigrateMojo.this.getLog().debug((CharSequence)("Adding tag '" + dirEntry.getPath() + "'"));
                    retval.add(dirEntry.getURL());
                }
            }
        });
        return retval;
    }

    protected SVNWCClient getWCClient() {
        return this.clientManager().getWCClient();
    }

    protected Collection<File> scanForChangelogs(File searchPath) {
        ArrayList<File> retval = new ArrayList<File>();
        if (searchPath.getName().endsWith("update")) {
            return Arrays.asList(searchPath.listFiles());
        }
        if (searchPath.isDirectory()) {
            for (File file : searchPath.listFiles()) {
                if (!file.isDirectory()) continue;
                retval.addAll(this.scanForChangelogs(file));
            }
        }
        return retval;
    }

    protected SVNClientManager clientManager() {
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)"lprzybylski", (String)"entr0py0");
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        return clientManager;
    }

    protected void generateUpdateLog(File changeLogFile, Collection<File> changelogs) throws FileNotFoundException, IOException {
        DocumentBuilder documentBuilder;
        changeLogFile.getParentFile().mkdirs();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        documentBuilder.setEntityResolver((EntityResolver)new LiquibaseEntityResolver());
        Document doc = documentBuilder.newDocument();
        Element changeLogElement = doc.createElementNS(XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace(), "databaseChangeLog");
        changeLogElement.setAttribute("xmlns", XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace());
        changeLogElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        changeLogElement.setAttribute("xsi:schemaLocation", "http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + XMLChangeLogSAXParser.getSchemaVersion() + ".xsd");
        doc.appendChild(changeLogElement);
        for (File changelog : changelogs) {
            doc.getDocumentElement().appendChild(this.includeNode(doc, changelog));
        }
        new DefaultXmlWriter().write(doc, (OutputStream)new FileOutputStream(changeLogFile));
    }

    protected Element includeNode(Document parentChangeLog, File changelog) throws IOException {
        Element retval = parentChangeLog.createElementNS(XMLChangeLogSAXParser.getDatabaseChangeLogNameSpace(), "include");
        retval.setAttribute("file", changelog.getCanonicalPath());
        return retval;
    }

    protected void doUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.dropFirst) {
            this.dropAll(liquibase);
        }
        liquibase.tag("undo");
        if (this.changesToApply > 0) {
            liquibase.update(this.changesToApply, this.contexts);
        } else {
            liquibase.update(this.contexts);
        }
    }

    protected void dropAll(Liquibase liquibase) throws LiquibaseException {
        boolean retry = true;
        while (retry) {
            try {
                liquibase.dropAll();
                retry = false;
            }
            catch (LiquibaseException e2) {
                this.getLog().info((CharSequence)e2.getMessage());
                if (e2.getMessage().indexOf("ORA-02443") < 0 && e2.getCause() != null && retry) {
                    boolean bl = retry = e2.getCause().getMessage().indexOf("ORA-02443") > -1;
                }
                if (!retry) {
                    throw e2;
                }
                this.getLog().info((CharSequence)"Got ORA-2443. Retrying...");
            }
        }
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "drop first? " + this.dropFirst));
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = this.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this " + "task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    protected Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field f;
        this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
        try {
            f = clazz.getDeclaredField(fieldName);
            if (f != null) {
                return f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
            try {
                f = clazz.getDeclaredField(fieldName);
                if (f == null) continue;
                return f;
            }
            catch (Exception exception) {
            }
        }
        throw new NoSuchFieldException("The field '" + fieldName + "' could not be " + "found in the class of any of its parent " + "classes.");
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else {
            field.set((Object)this, value);
        }
    }
}

