/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.liquibase;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.LiquibaseRollback;

public class RollbackMojo
extends LiquibaseRollback {
    public static final String DEFAULT_CHANGELOG_PATH = "src/main/scripts/changelogs";
    public static final String DEFAULT_UPDATE_FILE = "target/changelogs/update.xml";
    public static final String DEFAULT_UPDATE_PATH = "target/changelogs/update";
    public static final String DEFAULT_LBPROP_PATH = "target/test-classes/liquibase/";
    public static final String TEST_ROLLBACK_TAG = "test";
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    protected String driver;
    protected String url;
    protected WagonManager wagonManager;
    private String server;
    protected String username;
    protected String password;
    protected boolean emptyPassword;
    protected String defaultSchemaName;
    protected String databaseClass;
    protected boolean promptOnNonLocalDatabase;
    protected boolean includeArtifact;
    protected boolean includeTestOutputDirectory;
    protected boolean verbose;
    protected String logging;
    protected String propertyFile;
    protected boolean propertyFileWillOverride;
    protected boolean clearCheckSums;
    protected Properties systemProperties;
    protected File changeLogSavePath;
    protected URL changeLogTagUrl;
    protected File updatePath;
    @Parameter(property="project", required=true)
    protected MavenProject project;

    protected File getBasedir() {
        return this.project.getBasedir();
    }

    protected void doFieldHack() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field parentField = this.getDeclaredField(((Object)((Object)this)).getClass().getSuperclass(), field.getName());
                if (parentField == null) continue;
                this.getLog().debug((CharSequence)("Setting " + field.getName() + " in " + parentField.getDeclaringClass().getName() + " to " + field.get((Object)this)));
                parentField.set((Object)this, field.get((Object)this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected File[] getLiquibasePropertiesFiles() throws MojoExecutionException {
        try {
            File[] retval = new File(this.getBasedir(), DEFAULT_LBPROP_PATH).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            if (retval == null) {
                throw new NullPointerException();
            }
            return retval;
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to get liquibase properties files ");
            return new File[0];
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] propertyFiles;
        this.doFieldHack();
        try {
            Method meth = AbstractLiquibaseMojo.class.getDeclaredMethod("processSystemProperties", new Class[0]);
            meth.setAccessible(true);
            meth.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
        for (File props : propertyFiles = this.getLiquibasePropertiesFiles()) {
            try {
                this.propertyFile = props.getCanonicalPath();
                this.doFieldHack();
                this.configureFieldsAndValues(this.getFileOpener(artifactClassLoader));
                this.doFieldHack();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        this.changeLogFile = new File(this.changeLogSavePath, "update.xml").getPath();
        this.rollbackCount = 1;
        super.execute();
    }

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        liquibase.rollback("undo", this.contexts);
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = this.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this " + "task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    protected Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field f;
        this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
        try {
            f = clazz.getDeclaredField(fieldName);
            if (f != null) {
                return f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
            try {
                f = clazz.getDeclaredField(fieldName);
                if (f == null) continue;
                return f;
            }
            catch (Exception exception) {
            }
        }
        throw new NoSuchFieldException("The field '" + fieldName + "' could not be " + "found in the class of any of its parent " + "classes.");
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else {
            field.set((Object)this, value);
        }
    }
}

