/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.liquibase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.kualigan.maven.plugins.liquibase.MigrateHelper;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.MavenResourceAccessor;
import org.liquibase.maven.plugins.MavenUtils;

@Mojo(name="copy-database", requiresProject=false)
public class CopyMojo
extends AbstractLiquibaseChangeLogMojo {
    public static final String DEFAULT_CHANGELOG_PATH = "src/main/changelogs";
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";
    private static final String ALTERNATE_POM_FILE = "f";
    @Parameter(property="project", defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="interactiveMode", defaultValue="${settings.interactiveMode}")
    protected Boolean interactiveMode;
    @Component(role=WagonManager.class)
    protected WagonManager wagonManager;
    @Component(role=MigrateHelper.class)
    protected MigrateHelper migrator;
    @Parameter(property="lb.copy.source", required=true)
    private String source;
    @Parameter(property="lb.copy.source.schema")
    private String sourceSchema;
    private String sourceUser;
    private String sourcePass;
    @Parameter(property="lb.copy.source.driver")
    private String sourceDriverClass;
    @Parameter(property="lb.copy.source.url", required=true)
    private String sourceUrl;
    @Parameter(property="lb.copy.target", required=true)
    private String target;
    @Parameter(property="lb.copy.target.schema")
    private String targetSchema;
    private String targetUser;
    private String targetPass;
    @Parameter(property="lb.copy.target.driver")
    private String targetDriverClass;
    @Parameter(property="lb.copy.target.url", required=true)
    private String targetUrl;
    @Parameter(property="liquibase.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="liquibase.logging", defaultValue="INFO")
    protected String logging;
    @Parameter(property="liquibase.propertyFile")
    protected String propertyFile;
    @Parameter(property="liquibase.changeLogFile")
    protected String changeLogFile;
    @Parameter(property="liquibase.changeLogSavePath", defaultValue="${project.basedir}/target/changelogs")
    protected File changeLogSavePath;
    @Parameter(property="liquibase.dropFirst", defaultValue="false")
    protected boolean dropFirst;
    @Parameter(property="lb.copy.data", defaultValue="true")
    protected boolean stateSaved;
    @Parameter(defaultValue="${maven.home}")
    protected File mavenHome;

    protected Boolean isStateSaved() {
        return this.stateSaved;
    }

    protected File getBasedir() {
        return this.project.getBasedir();
    }

    protected String getChangeLogFile() throws MojoExecutionException {
        if (this.changeLogFile != null) {
            return this.changeLogFile;
        }
        try {
            this.changeLogFile = this.changeLogSavePath.getCanonicalPath();
            new File(this.changeLogFile).mkdirs();
            this.changeLogFile = this.changeLogFile + File.separator + this.targetUser;
            return this.changeLogFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception getting the location of the change log file: " + e.getMessage(), e);
        }
    }

    protected void doFieldHack() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field parentField = this.getDeclaredField(((Object)((Object)this)).getClass().getSuperclass(), field.getName());
                if (parentField == null) continue;
                this.getLog().debug((CharSequence)("Setting " + field.getName() + " in " + parentField.getDeclaringClass().getName() + " to " + field.get((Object)this)));
                parentField.set((Object)this, field.get((Object)this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public ClassLoader getMavenArtifactClassloader() throws MojoExecutionException {
        try {
            return MavenUtils.getArtifactClassloader((MavenProject)this.project, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass(), (Log)this.getLog(), (boolean)false);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public String lookupDriverFor(String url) {
        for (Database databaseImpl : DatabaseFactory.getInstance().getImplementedDatabases()) {
            String driver = databaseImpl.getDefaultDriver(url);
            if (driver == null) continue;
            return driver;
        }
        return null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null || this.project.getArtifactId().equalsIgnoreCase("standalone-pom")) {
            this.getLog().info((CharSequence)"Using standalone-pom. No project. I have to create one.");
            this.generateArchetype(this.getMavenHome(), new Properties(){
                {
                    this.setProperty("archetypeGroupId", "org.kualigan.maven.archetypes");
                    this.setProperty("archetypeArtifactId", "lb-copy-archetype");
                    this.setProperty("archetypeVersion", "1.1.7");
                    this.setProperty("groupId", "org.kualigan.liquibase");
                    this.setProperty("artifactId", "copy");
                    this.setProperty("version", "1.0.0-SNAPSHOT");
                }
            });
            this.invokeCopy(this.getMavenHome(), new Properties(){
                {
                    this.setProperty("lb.copy.source", CopyMojo.this.source);
                    this.setProperty("lb.copy.source.url", CopyMojo.this.sourceUrl);
                    if (CopyMojo.this.sourceDriverClass != null) {
                        this.setProperty("lb.copy.source.driver", CopyMojo.this.sourceDriverClass);
                    }
                    if (CopyMojo.this.sourceSchema != null) {
                        this.setProperty("lb.copy.source.schema", CopyMojo.this.sourceSchema);
                    }
                    this.setProperty("lb.copy.target", CopyMojo.this.target);
                    this.setProperty("lb.copy.target.url", CopyMojo.this.targetUrl);
                    if (CopyMojo.this.targetDriverClass != null) {
                        this.setProperty("lb.copy.target.driver", CopyMojo.this.targetDriverClass);
                    }
                    if (CopyMojo.this.targetSchema != null) {
                        this.setProperty("lb.copy.target.schema", CopyMojo.this.targetSchema);
                    }
                }
            });
        } else {
            this.doCopy();
        }
    }

    public void invokeCopy(File mavenHome, Properties copyProperties) throws MojoExecutionException {
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        invoker.setWorkingDirectory(new File(System.getProperty("user.dir") + File.separator + "copy"));
        String additionalArguments = "";
        InvocationRequest req = new DefaultInvocationRequest().setInteractive(true).setProperties(copyProperties);
        this.setupRequest(req, "");
        req.setGoals((List)new ArrayList<String>(){
            {
                this.add("lb:copy-database");
            }
        });
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MojoExecutionException("Error executing Maven.", (Exception)invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'");
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven build.", (Exception)((Object)e));
        }
    }

    public void generateArchetype(File mavenHome, Properties archetypeProperties) throws MojoExecutionException {
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        String additionalArguments = "";
        InvocationRequest req = new DefaultInvocationRequest().setInteractive(false).setProperties(archetypeProperties);
        this.setupRequest(req, "");
        req.setGoals((List)new ArrayList<String>(){
            {
                this.add("archetype:generate");
            }
        });
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MojoExecutionException("Error executing Maven.", (Exception)invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'");
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven build.", (Exception)((Object)e));
        }
    }

    protected void setupRequest(InvocationRequest req, String additionalArguments) throws MojoExecutionException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)additionalArguments);
            CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                req.setDebug(false);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P')) {
                String[] profiles = cli.getOptionValues('P');
                ArrayList<String> activatedProfiles = new ArrayList<String>();
                ArrayList<String> deactivatedProfiles = new ArrayList<String>();
                if (profiles != null) {
                    for (int i = 0; i < profiles.length; ++i) {
                        StringTokenizer profileTokens = new StringTokenizer(profiles[i], ",");
                        while (profileTokens.hasMoreTokens()) {
                            String profileAction = profileTokens.nextToken().trim();
                            if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                                deactivatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            if (profileAction.startsWith("+")) {
                                activatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            activatedProfiles.add(profileAction);
                        }
                    }
                }
                if (!deactivatedProfiles.isEmpty()) {
                    this.getLog().warn((CharSequence)("Explicit profile deactivation is not yet supported. The following profiles will NOT be deactivated: " + StringUtils.join(deactivatedProfiles.iterator(), (String)", ")));
                }
                if (!activatedProfiles.isEmpty()) {
                    req.setProfiles(activatedProfiles);
                }
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getLog().warn((CharSequence)"Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getLog().warn((CharSequence)"Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
            if (cli.hasOption(ALTERNATE_POM_FILE)) {
                if (req.getPomFileName() != null) {
                    this.getLog().info((CharSequence)"pomFileName is already set, ignoring the -f argument");
                } else {
                    req.setPomFileName(cli.getOptionValue(ALTERNATE_POM_FILE));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    protected void doCopy() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo info;
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        if (this.source != null && (info = this.wagonManager.getAuthenticationInfo(this.source)) != null) {
            this.sourceUser = info.getUserName();
            this.sourcePass = info.getPassword();
        }
        this.sourceDriverClass = this.lookupDriverFor(this.sourceUrl);
        if (this.sourceSchema == null) {
            this.sourceSchema = this.sourceUser;
        }
        if (this.target != null && (info = this.wagonManager.getAuthenticationInfo(this.target)) != null) {
            this.targetUser = info.getUserName();
            this.targetPass = info.getPassword();
        }
        if (this.targetSchema == null) {
            this.targetSchema = this.targetUser;
        }
        this.targetDriverClass = this.lookupDriverFor(this.targetUrl);
        this.getLog().info((CharSequence)("project " + this.project));
        ClassLoader artifactClassLoader = this.getMavenArtifactClassloader();
        try {
            LogFactory.setLoggingLevel((String)this.logging);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Failed to set logging level: " + e.getMessage(), (Exception)e);
        }
        Database lbSource = this.createSourceDatabase();
        Database lbTarget = this.createTargetDatabase();
        try {
            this.exportSchema(lbSource, lbTarget);
            this.updateSchema(lbTarget);
            if (this.isStateSaved().booleanValue()) {
                this.getLog().info((CharSequence)("Starting data load from schema " + this.sourceSchema));
                this.migrator.migrate(lbSource, lbTarget, this.getLog(), this.interactiveMode);
            }
            try {
                this.updateConstraints(lbTarget, artifactClassLoader);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (lbTarget instanceof H2Database) {
                Statement st = ((JdbcConnection)lbTarget.getConnection()).createStatement();
                st.execute("SHUTDOWN DEFRAG");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            try {
                if (lbSource != null) {
                    lbSource.close();
                }
                if (lbTarget != null) {
                    lbTarget.close();
                }
            }
            catch (Exception e) {}
        }
        this.cleanup(lbSource);
        this.cleanup(lbTarget);
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"");
    }

    protected void updateSchema(Database target) throws MojoExecutionException {
        ClassLoader artifactClassLoader = this.getMavenArtifactClassloader();
        this.updateTables(target, artifactClassLoader);
        this.updateSequences(target, artifactClassLoader);
        this.updateViews(target, artifactClassLoader);
        this.updateIndexes(target, artifactClassLoader);
    }

    protected void updateTables(Database target, ClassLoader artifactClassLoader) throws MojoExecutionException {
        try {
            Liquibase liquibase = new Liquibase(this.getChangeLogFile() + "-tab.xml", this.getFileOpener(artifactClassLoader), target);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void updateSequences(Database target, ClassLoader artifactClassLoader) throws MojoExecutionException {
        try {
            Liquibase liquibase = new Liquibase(this.getChangeLogFile() + "-seq.xml", this.getFileOpener(artifactClassLoader), target);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void updateViews(Database target, ClassLoader artifactClassLoader) throws MojoExecutionException {
        try {
            Liquibase liquibase = new Liquibase(this.getChangeLogFile() + "-vw.xml", this.getFileOpener(artifactClassLoader), target);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void updateIndexes(Database target, ClassLoader artifactClassLoader) throws MojoExecutionException {
        try {
            Liquibase liquibase = new Liquibase(this.getChangeLogFile() + "-idx.xml", this.getFileOpener(artifactClassLoader), target);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void updateConstraints(Database target, ClassLoader artifactClassLoader) throws MojoExecutionException {
        try {
            Liquibase liquibase = new Liquibase(this.getChangeLogFile() + "-cst.xml", this.getFileOpener(artifactClassLoader), target);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected Database createSourceDatabase() throws MojoExecutionException {
        try {
            DatabaseFactory factory = DatabaseFactory.getInstance();
            Database retval = factory.findCorrectDatabaseImplementation((DatabaseConnection)this.openConnection(this.sourceUrl, this.sourceUser, this.sourcePass, this.sourceDriverClass, ""));
            retval.setDefaultSchemaName(this.sourceSchema);
            return retval;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected Database createTargetDatabase() throws MojoExecutionException {
        try {
            DatabaseFactory factory = DatabaseFactory.getInstance();
            Database retval = factory.findCorrectDatabaseImplementation((DatabaseConnection)this.openConnection(this.targetUrl, this.targetUser, this.targetPass, this.targetDriverClass, ""));
            retval.setDefaultSchemaName(this.targetSchema);
            return retval;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void dropAll(Liquibase liquibase) throws LiquibaseException {
        boolean retry = true;
        while (retry) {
            try {
                liquibase.dropAll();
                retry = false;
            }
            catch (LiquibaseException e2) {
                this.getLog().info((CharSequence)e2.getMessage());
                if (e2.getMessage().indexOf("ORA-02443") < 0 && e2.getCause() != null && retry) {
                    boolean bl = retry = e2.getCause().getMessage().indexOf("ORA-02443") > -1;
                }
                if (!retry) {
                    throw e2;
                }
                this.getLog().info((CharSequence)"Got ORA-2443. Retrying...");
            }
        }
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "drop first? " + this.dropFirst));
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = this.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this " + "task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    protected Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field f;
        this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
        try {
            f = clazz.getDeclaredField(fieldName);
            if (f != null) {
                return f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            this.getLog().debug((CharSequence)("Checking " + clazz.getName() + " for '" + fieldName + "'"));
            try {
                f = clazz.getDeclaredField(fieldName);
                if (f == null) continue;
                return f;
            }
            catch (Exception exception) {
            }
        }
        throw new NoSuchFieldException("The field '" + fieldName + "' could not be " + "found in the class of any of its parent " + "classes.");
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else {
            field.set((Object)this, value);
        }
    }

    protected void exportConstraints(Database source, Database target) throws MojoExecutionException {
        this.export(source, target, "foreignKeys", "-cst.xml");
    }

    protected void exportIndexes(Database source, Database target) throws MojoExecutionException {
        this.export(source, target, "indexes", "-idx.xml");
    }

    protected void exportViews(Database source, Database target) throws MojoExecutionException {
        this.export(source, target, "views", "-vw.xml");
    }

    protected void exportTables(Database source, Database target) throws MojoExecutionException {
        this.export(source, target, "tables, primaryKeys, uniqueConstraints", "-tab.xml");
    }

    protected void exportSequences(Database source, Database target) throws MojoExecutionException {
        this.export(source, target, "sequences", "-seq.xml");
    }

    protected void export(Database source, Database target, String sourceTypes, String suffix) throws MojoExecutionException {
        try {
            CatalogAndSchema catalogAndSchema = source.getDefaultSchema();
            SnapshotControl snapshotControl = new SnapshotControl(source, sourceTypes);
            CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema)}, sourceTypes);
            DatabaseSnapshot referenceSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), source, snapshotControl);
            DatabaseSnapshot comparisonSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), target, snapshotControl);
            DiffResult results = DiffGeneratorFactory.getInstance().compare(referenceSnapshot, comparisonSnapshot, compareControl);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while exporting to the target: " + e.getMessage(), e);
        }
    }

    protected void exportSchema(Database source, Database target) throws MojoExecutionException {
        try {
            this.exportTables(source, target);
            this.exportSequences(source, target);
            this.exportViews(source, target);
            this.exportIndexes(source, target);
            this.exportConstraints(source, target);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while exporting the source schema: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcConnection openConnection(String url, String username, String password, String className, String schema) throws MojoExecutionException {
        Connection retval = null;
        int retry_count = 0;
        int max_retry = 5;
        while (retry_count < 5) {
            try {
                this.getLog().debug((CharSequence)("Loading schema " + schema + " at url " + url));
                Class.forName(className);
                retval = DriverManager.getConnection(url, username, password);
                retval.setAutoCommit(true);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Database lock acquisition failure") || e instanceof NullPointerException) continue;
                throw new MojoExecutionException(e.getMessage(), e);
            }
            finally {
                ++retry_count;
            }
        }
        return new JdbcConnection(retval);
    }

    protected ResourceAccessor getFileOpener(ClassLoader cl) {
        MavenResourceAccessor mFO = new MavenResourceAccessor(cl);
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor(this.project.getBasedir().getAbsolutePath());
        return new CompositeResourceAccessor(new ResourceAccessor[]{mFO, fsFO});
    }

    public void setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }
}

