/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins.liquibase;

import java.io.PrintStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.annotations.Component;
import org.kualigan.maven.plugins.liquibase.MigrateHelper;

@Component(role=MigrateHelper.class, hint="default")
public class DefaultMigrateHelper
implements MigrateHelper {
    public static final String ROLE_HINT = "default";
    private static final String[] carr = new String[]{"|", "\\", "-", "/"};
    private static final String RECORD_COUNT_QUERY = "select count(*) as \"COUNT\" from %s";
    private static final String SELECT_ALL_QUERY = "select * from %s";
    private static final String INSERT_STATEMENT = "insert into %s (%s) values (%s)";
    private static final String DATE_CONVERSION = "TO_DATE('%s', 'YYYYMMDDHH24MISS')";
    private static final String COUNT_FIELD = "COUNT";
    private static final String LIQUIBASE_TABLE = "DATABASECHANGELOG";
    private static final int[] QUOTED_TYPES = new int[]{1, 12, 92, -1, 91, 93};
    private static final String HSQLDB_PUBLIC = "PUBLIC";
    private static final int MAX_THREADS = 3;
    private Log log;
    private Database source;
    private Database target;
    private int threadCount;
    private Boolean interactiveMode;

    public DefaultMigrateHelper() {
        boolean threadCount = true;
    }

    @Override
    public void setSource(Database source) {
        this.source = source;
    }

    @Override
    public Database getSource() {
        return this.source;
    }

    @Override
    public void setTarget(Database target) {
        this.target = target;
    }

    @Override
    public Database getTarget() {
        return this.target;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public void migrate(Database source, Database target, Log log, Boolean interactiveMode) throws MojoExecutionException {
        this.setTarget(target);
        this.setSource(source);
        this.setLog(log);
        this.interactiveMode = interactiveMode;
        this.migrate();
    }

    public void migrate() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Migrating data from " + this.source.getConnection().getURL() + " to " + this.target.getConnection().getURL()));
        Incrementor recordCountIncrementor = new Incrementor();
        Map<String, Integer> tableData = this.getTableData(recordCountIncrementor);
        this.getLog().debug((CharSequence)("Copying " + tableData.size() + " tables"));
        float recordVisitor = 0.0f;
        ProgressObserver progressObserver = new ProgressObserver(recordCountIncrementor.getValue(), 48.0f, 0.48f, "\r|%s[%s] %3d%% (%d/%d) records");
        ProgressObservable observable = new ProgressObservable();
        observable.addObserver(progressObserver);
        ThreadGroup tgroup = new ThreadGroup("Migration Threads");
        for (String tableName : tableData.keySet()) {
            HashMap columns = new HashMap();
            this.migrate(tableName, observable);
        }
        try {
            while (tgroup.activeCount() > 0) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void migrate(String tableName, ProgressObservable observable) throws MojoExecutionException {
        sourceDb = (JdbcConnection)this.getSource().getConnection();
        targetDb = (JdbcConnection)this.getTarget().getConnection();
        columns = this.getColumnMap(tableName);
        if (columns.size() < 1) {
            this.getLog().debug((CharSequence)("Columns are empty for " + tableName));
            return;
        }
        toStatement = this.prepareStatement(targetDb, tableName, columns);
        fromStatement = null;
        hasClob = columns.values().contains(2005);
        recordsLost = 0;
        try {
            fromStatement = sourceDb.createStatement();
            results = fromStatement.executeQuery(String.format("select * from %s", new Object[]{tableName}));
            try {
                while (results.next()) {
                    try {
                        toStatement.clearParameters();
                        i = 1;
                        for (String columnName : columns.keySet()) {
                            value = results.getObject(columnName);
                            if (value != null) {
                                try {
                                    this.handleLob(toStatement, value, i);
                                }
                                catch (Exception e) {
                                    if (this.getLog().isDebugEnabled() && !Clob.class.isAssignableFrom(value.getClass())) ** GOTO lbl29
                                }
                            } else {
                                toStatement.setObject(i, value);
                            }
lbl29:
                            // 4 sources

                            ++i;
                        }
                        retry = true;
                        retry_count = 0;
                        while (retry) {
                            try {
                                toStatement.execute();
                                retry = false;
                            }
                            catch (SQLException sqle) {
                                retry = false;
                                if (sqle.getMessage().contains("ORA-00942")) {
                                    this.getLog().debug((CharSequence)("Couldn't find " + tableName));
                                    if (!this.getLog().isDebugEnabled()) continue;
                                    this.getLog().debug((CharSequence)("Tried insert statement " + this.getStatementBuffer(tableName, columns)), (Throwable)sqle);
                                    continue;
                                }
                                if (sqle.getMessage().contains("ORA-12519")) {
                                    retry = true;
                                    if (!this.getLog().isDebugEnabled()) continue;
                                    this.getLog().debug((CharSequence)("Tried insert statement " + this.getStatementBuffer(tableName, columns)), (Throwable)sqle);
                                    continue;
                                }
                                if (sqle.getMessage().contains("IN or OUT")) {
                                    if (!this.getLog().isDebugEnabled()) continue;
                                    this.getLog().debug((CharSequence)("Column count was " + columns.keySet().size()), (Throwable)sqle);
                                    continue;
                                }
                                if (sqle.getMessage().contains("Error reading")) {
                                    if (retry_count > 5) {
                                        if (this.getLog().isDebugEnabled()) {
                                            this.getLog().debug((CharSequence)("Tried insert statement " + this.getStatementBuffer(tableName, columns)), (Throwable)sqle);
                                        }
                                        retry = false;
                                    }
                                    ++retry_count;
                                    continue;
                                }
                                if (!this.getLog().isDebugEnabled()) continue;
                            }
                        }
                    }
                    catch (Exception e) {
                        ++recordsLost;
                        throw e;
                    }
                    finally {
                        observable.incrementRecord();
                    }
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            if (sourceDb != null) {
                try {
                    if (sourceDb.getMetaData().getDriverName().toLowerCase().contains("hsqldb")) {
                        st = sourceDb.createStatement();
                        st.execute("CHECKPOINT");
                        st.close();
                    }
                    fromStatement.close();
                }
                catch (Exception e) {}
            }
            if (targetDb != null) {
                try {
                    targetDb.commit();
                    if (targetDb.getMetaData().getDriverName().toLowerCase().contains("hsql")) {
                        st = targetDb.createStatement();
                        st.execute("CHECKPOINT");
                        st.close();
                    }
                    toStatement.close();
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)"Error closing database connection");
                    e.printStackTrace();
                }
            }
            columns.clear();
        }
    }

    protected void handleLob(PreparedStatement toStatement, Object value, int i) throws SQLException {
        if (Clob.class.isAssignableFrom(value.getClass())) {
            toStatement.setAsciiStream(i, ((Clob)value).getAsciiStream(), ((Clob)value).length());
        } else if (Blob.class.isAssignableFrom(value.getClass())) {
            toStatement.setBinaryStream(i, ((Blob)value).getBinaryStream(), ((Blob)value).length());
        } else {
            toStatement.setObject(i, value);
        }
    }

    protected PreparedStatement prepareStatement(JdbcConnection conn, String tableName, Map<String, Integer> columns) throws MojoExecutionException {
        String statement = this.getStatementBuffer(tableName, columns);
        try {
            return conn.prepareStatement(statement);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected String getStatementBuffer(String tableName, Map<String, Integer> columns) {
        String retval = null;
        StringBuilder names = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String columnName : columns.keySet()) {
            names.append(columnName).append(",");
            values.append("?,");
        }
        names.setLength(names.length() - 1);
        values.setLength(values.length() - 1);
        retval = String.format(INSERT_STATEMENT, tableName, names, values);
        return retval;
    }

    protected boolean isValidTable(DatabaseMetaData metadata, String tableName) {
        return !tableName.startsWith("BIN$") && !tableName.toUpperCase().startsWith(LIQUIBASE_TABLE) && !this.isSequence(metadata, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSequence(DatabaseMetaData metadata, String tableName) {
        JdbcConnection source = (JdbcConnection)this.getSource().getConnection();
        try {
            boolean hasId;
            int columnCount;
            block10: {
                ResultSet rs = source.getMetaData().getColumns(null, this.getSource().getDefaultSchemaName(), tableName, null);
                columnCount = 0;
                hasId = false;
                try {
                    while (rs.next()) {
                        ++columnCount;
                        if (!"yes".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                        hasId = true;
                    }
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return columnCount == 1 && hasId;
                }
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return columnCount == 1 && hasId;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Map<String, Integer> getTableData(Incrementor incrementor) throws MojoExecutionException {
        JdbcConnection sourceConn = (JdbcConnection)this.getSource().getConnection();
        JdbcConnection targetConn = (JdbcConnection)this.getTarget().getConnection();
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        ArrayList<String> toRemove = new ArrayList<String>();
        this.getLog().debug((CharSequence)("Looking up table names in schema " + this.getSource().getDefaultSchemaName()));
        try {
            DatabaseMetaData metadata = sourceConn.getMetaData();
            ResultSet tableResults = metadata.getTables(sourceConn.getCatalog(), this.getSource().getDefaultSchemaName(), null, new String[]{"TABLE"});
            while (tableResults.next()) {
                String tableName = tableResults.getString("TABLE_NAME");
                if (!this.isValidTable(metadata, tableName) || tableName.toUpperCase().startsWith(LIQUIBASE_TABLE)) continue;
                int rowCount = this.getTableRecordCount(sourceConn, tableName);
                if (rowCount < 1) {
                    // empty if block
                }
                incrementor.increment(rowCount);
                retval.put(tableName, rowCount);
            }
            tableResults.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            for (String tableName : retval.keySet()) {
                ResultSet tableResults = targetConn.getMetaData().getTables(targetConn.getCatalog(), this.getTarget().getDefaultSchemaName(), null, new String[]{"TABLE"});
                if (!tableResults.next()) {
                    this.getLog().debug((CharSequence)("Removing " + tableName));
                    toRemove.add(tableName);
                }
                tableResults.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        for (String tableName : toRemove) {
            retval.remove(tableName);
        }
        return retval;
    }

    protected Map<String, Integer> getColumnMap(String tableName) throws MojoExecutionException {
        JdbcConnection targetDb = (JdbcConnection)this.target.getConnection();
        JdbcConnection sourceDb = (JdbcConnection)this.source.getConnection();
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        ArrayList toRemove = new ArrayList();
        try {
            Statement state = targetDb.createStatement();
            ResultSet altResults = state.executeQuery("select * from " + tableName + " where 1 = 0");
            ResultSetMetaData metadata = altResults.getMetaData();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                retval.put(metadata.getColumnName(i), metadata.getColumnType(i));
            }
            altResults.close();
            state.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        for (String column : retval.keySet()) {
            try {
                Statement state = targetDb.createStatement();
                ResultSet altResults = state.executeQuery("select * from " + tableName + " where 1 = 0");
                ResultSetMetaData metadata = altResults.getMetaData();
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    retval.put(metadata.getColumnName(i), metadata.getColumnType(i));
                }
                altResults.close();
                state.close();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        for (String column : toRemove) {
            retval.remove(column);
        }
        return retval;
    }

    protected int getTableRecordCount(JdbcConnection conn, String tableName) throws MojoExecutionException {
        String query = String.format(RECORD_COUNT_QUERY, tableName);
        Statement statement = null;
        try {
            statement = conn.createStatement();
            ResultSet results = statement.executeQuery(query);
            results.next();
            int retval = results.getInt(COUNT_FIELD);
            results.close();
            int n = retval;
            return n;
        }
        catch (Exception e) {
            if (e.getMessage().contains("ORA-00942")) {
                this.getLog().debug((CharSequence)("Couldn't find " + tableName));
                this.getLog().debug((CharSequence)("Tried insert statement " + query));
            }
            this.getLog().debug((CharSequence)("Exception executing " + query));
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (Exception e) {}
        }
    }

    private class ProgressObserver
    implements Observer {
        private float total;
        private float progress;
        private float length;
        private float ratio;
        private String template;
        private float count;
        private PrintStream out;

        public ProgressObserver(float total, float length, float ratio, String template) {
            this.total = total;
            this.template = template;
            this.ratio = ratio;
            this.length = length;
            this.count = 0.0f;
            this.out = System.out;
        }

        @Override
        public synchronized void update(Observable o, Object arg) {
            int x;
            this.count += 1.0f;
            int percent = (int)(this.count / this.total * 100.0f);
            int progress = (int)(this.count / this.total * (100.0f * this.ratio));
            StringBuilder progressBuffer = new StringBuilder();
            for (x = 0; x < progress; ++x) {
                progressBuffer.append('=');
            }
            x = progress;
            while ((float)x < this.length) {
                progressBuffer.append(' ');
                ++x;
            }
            int roll = (int)(this.count / (this.total / 1000.0f));
            if (DefaultMigrateHelper.this.interactiveMode.booleanValue()) {
                this.out.print(String.format(this.template, progressBuffer, carr[roll % carr.length], percent, (int)this.count, (int)this.total));
            } else if (this.count % 5000.0f == 0.0f || this.count == this.total) {
                this.out.println(String.format("(%s)%% %s of %s records", (int)(this.count / this.total * 100.0f), (int)this.count, (int)this.total));
            }
        }
    }

    private class ProgressObservable
    extends Observable {
        private ProgressObservable() {
        }

        public void incrementRecord() {
            this.setChanged();
            this.notifyObservers();
            this.clearChanged();
        }
    }

    private class Incrementor {
        private int value = 0;

        public int getValue() {
            return this.value;
        }

        public void increment() {
            ++this.value;
        }

        public void increment(int by) {
            this.value += by;
        }
    }
}

