/*
 * Decompiled with CFR 0.152.
 */
package org.kualigan.maven.plugins;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.kualigan.maven.plugins.StartRedisMojo;
import redis.server.netty.RedisCommandDecoder;
import redis.server.netty.RedisCommandHandler;
import redis.server.netty.RedisReplyEncoder;
import redis.server.netty.RedisServer;
import redis.server.netty.SimpleRedisServer;

public abstract class AbstractStartRedisMojo
extends AbstractMojo {
    public static final String REDIS_GROUP_CONTEXT_PROPERTY_NAME = StartRedisMojo.class.getName() + File.pathSeparator + "redis";

    public abstract void execute() throws MojoExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Boolean isForked) throws InterruptedException {
        final RedisCommandHandler commandHandler = new RedisCommandHandler((RedisServer)new SimpleRedisServer());
        ServerBootstrap b = new ServerBootstrap();
        final DefaultEventExecutorGroup group = new DefaultEventExecutorGroup(1);
        this.getPluginContext().put(REDIS_GROUP_CONTEXT_PROPERTY_NAME, group);
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).localAddress(this.getPort())).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new RedisCommandDecoder()});
                    p.addLast(new ChannelHandler[]{new RedisReplyEncoder()});
                    p.addLast((EventExecutorGroup)group, new ChannelHandler[]{commandHandler});
                }
            });
            StringBuffer message = new StringBuffer();
            if (isForked.booleanValue()) {
                message.append("Forking Redis");
            } else {
                message.append("Starting Redis");
            }
            message.append("(port=").append(this.getPort()).append(") server...");
            this.getLog().info((CharSequence)message.toString());
            ChannelFuture f = b.bind();
            if (!isForked.booleanValue()) {
                f.sync();
                f.channel().closeFuture().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    public abstract void setPort(int var1);

    public abstract int getPort();
}

