/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.maven.plugins.handlebars;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.arnx.jsonic.JSON;
import net.unit8.maven.plugins.handlebars.GitHubDownloadDto;
import net.unit8.maven.plugins.handlebars.KnownHelpers;
import net.unit8.maven.plugins.handlebars.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlebarsEngine {
    private File cacheDir;
    private String encoding;
    private String handlebarsName;
    private URL handlebarsUrl;
    private static final URI handlebarsDownloadsUri;
    private static final Log LOG;
    private List<String> knownHelpers = Collections.emptyList();
    private Boolean knownHelpersOnly;

    public HandlebarsEngine(String handlebarsName) throws MojoExecutionException {
        this.handlebarsName = handlebarsName;
    }

    public void startup() throws MojoExecutionException {
        this.handlebarsUrl = this.getClass().getClassLoader().getResource("script/" + this.handlebarsName);
        if (this.handlebarsUrl == null) {
            File cacheFile = new File(this.cacheDir, this.handlebarsName);
            if (!cacheFile.exists()) {
                this.fetchHandlebars(this.handlebarsName);
            }
            try {
                this.handlebarsUrl = cacheFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid handlebars cache file.", (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void precompile(Collection<File> templates, File outputFile, boolean purgeWhitespace) throws IOException {
        Context cx = Context.enter();
        PrintWriter out = null;
        LOG.info((CharSequence)("precompile " + templates + " to " + outputFile));
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.encoding));
            out.print("(function() {\n  var template = Handlebars.template, templates = Handlebars.templates = Handlebars.templates || {};\n");
            ScriptableObject global = cx.initStandardObjects();
            InputStreamReader in = new InputStreamReader(this.handlebarsUrl.openStream());
            cx.evaluateReader((Scriptable)global, (Reader)in, this.handlebarsName, 1, null);
            IOUtils.closeQuietly((Reader)in);
            Options options = new Options(new KnownHelpers(this.knownHelpers), this.knownHelpersOnly);
            ScriptableObject.putProperty((Scriptable)global, (String)"options", (Object)((Object)options));
            for (File template : templates) {
                String data = FileUtils.readFileToString((File)template, (String)this.encoding);
                if (purgeWhitespace) {
                    data = StringUtils.replaceEach((String)data, (String[])new String[]{"\n", "\r", "\t"}, (String[])new String[]{"", "", ""});
                }
                ScriptableObject.putProperty((Scriptable)global, (String)"data", (Object)data);
                Object obj = cx.evaluateString((Scriptable)global, "Handlebars.precompile(String(data), options);", "<cmd>", 1, null);
                out.println("templates['" + FilenameUtils.getBaseName((String)template.getName()) + "']=template(" + obj.toString() + ");");
            }
        }
        catch (Throwable throwable) {
            Context.exit();
            if (out != null) {
                out.println("})();");
            }
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        Context.exit();
        if (out != null) {
            out.println("})();");
        }
        IOUtils.closeQuietly((Writer)out);
    }

    protected void fetchHandlebars(String handlebarsName) throws MojoExecutionException {
        String downloadUrl = null;
        URLConnection conn = null;
        try {
            conn = handlebarsDownloadsUri.toURL().openConnection();
            List githubDownloadDtoList = (List)JSON.decode((InputStream)conn.getInputStream(), (Type)new ArrayList<GitHubDownloadDto>(){}.getClass().getGenericSuperclass());
            for (GitHubDownloadDto githubDownloadDto : githubDownloadDtoList) {
                if (!StringUtils.equals((String)githubDownloadDto.getName(), (String)handlebarsName)) continue;
                downloadUrl = githubDownloadDto.getHtmlUrl();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure fetch handlebars.", e);
        }
        finally {
            if (conn != null) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
        conn = null;
        try {
            if (!this.cacheDir.exists()) {
                FileUtils.forceMkdir((File)this.cacheDir);
            }
            if (((HttpURLConnection)(conn = new URL(downloadUrl).openConnection())).getResponseCode() == 302) {
                String location = conn.getHeaderField("Location");
                ((HttpURLConnection)conn).disconnect();
                conn = new URL(location).openConnection();
            }
            LOG.info((CharSequence)("Fetch handlebars.js from GitHub (" + conn.getURL() + ")"));
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)new FileOutputStream(new File(this.cacheDir, handlebarsName)));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure fetch handlebars.", e);
        }
        finally {
            if (conn != null) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setKnownHelpers(List<String> knownHelpers) {
        this.knownHelpers = knownHelpers;
    }

    public void setKnownHelpersOnly(Boolean knownHelpersOnly) {
        this.knownHelpersOnly = knownHelpersOnly;
    }

    static {
        LOG = new SystemStreamLog();
        try {
            handlebarsDownloadsUri = new URI("https://api.github.com/repos/wycats/handlebars.js/downloads");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("GitHub url is invalid?");
        }
    }
}

