/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.maven.plugins.handlebars;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.unit8.maven.plugins.handlebars.HandlebarsEngine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class PrecompileMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String[] templateExtensions;
    protected Boolean purgeWhitespace;
    protected File sourceDirectory;
    protected File outputDirectory;
    protected List<String> knownHelpers;
    protected Boolean knownHelpersOnly;
    protected Boolean preserveHierarchy;
    protected String handlebarsName;
    protected String encoding = "UTF-8";
    private HandlebarsEngine handlebarsEngine;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.sourceDirectory.getAbsolutePath());
        }
        if (!this.outputDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)this.outputDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failure to make an output directory.", (Exception)e);
            }
        }
        if (this.preserveHierarchy == null) {
            this.preserveHierarchy = true;
        }
        if (this.templateExtensions == null) {
            this.templateExtensions = new String[]{"html", "hbs"};
        }
        if (this.purgeWhitespace == null) {
            this.purgeWhitespace = false;
        }
        this.handlebarsEngine = new HandlebarsEngine(this.handlebarsName);
        this.handlebarsEngine.setEncoding(this.encoding);
        this.handlebarsEngine.setKnownHelpersOnly(this.knownHelpersOnly);
        if (this.knownHelpers != null) {
            this.getLog().debug((CharSequence)("Known helpers " + this.knownHelpers.toString()));
            this.handlebarsEngine.setKnownHelpers(this.knownHelpers);
        }
        if (this.project != null) {
            this.handlebarsEngine.setCacheDir(new File(this.project.getBuild().getDirectory(), "handlebars-maven-plugins/script"));
        }
        this.handlebarsEngine.startup();
        try {
            this.visit(this.sourceDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure to precompile handlebars templates.", (Exception)e);
        }
    }

    protected void visit(File directory) throws IOException {
        File[] children;
        this.precompile(directory);
        for (File child : children = directory.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
            this.visit(child);
        }
    }

    protected void precompile(File directory) throws IOException {
        Collection templates = FileUtils.listFiles((File)directory, (String[])this.templateExtensions, (boolean)false);
        if (templates.isEmpty()) {
            return;
        }
        this.handlebarsEngine.precompile(templates, this.getOutputFile(directory), this.purgeWhitespace);
    }

    private File getOutputFile(File directory) throws IOException {
        if (this.preserveHierarchy.booleanValue()) {
            String relativePath = this.sourceDirectory.toURI().relativize(directory.toURI()).getPath();
            File outputBaseDir = new File(this.outputDirectory, relativePath);
            if (!outputBaseDir.exists()) {
                FileUtils.forceMkdir((File)outputBaseDir);
            }
            return new File(outputBaseDir, directory.getName() + ".js");
        }
        String relativePath = this.sourceDirectory.toURI().relativize(directory.toURI()).getPath();
        String name = StringUtils.chomp((String)relativePath, (String)"/").replace('/', '-');
        if (StringUtils.isEmpty((String)name)) {
            name = "index";
        }
        return new File(this.outputDirectory, name + ".js");
    }
}

