/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import org.kurento.commons.Address;
import org.kurento.commons.exception.KurentoException;

public class PropertiesManager {
    private static PropertyHolder propertyHolder = new PropertyHolder(){

        @Override
        public String getProperty(String property) {
            return System.getProperty(property);
        }
    };

    public static void setPropertyHolder(PropertyHolder propertyHolder) {
        PropertiesManager.propertyHolder = propertyHolder;
    }

    public static String getProperty(String property) {
        return propertyHolder.getProperty(property);
    }

    public static String getPropertyOrException(String property, String exceptionMessage) {
        String value = PropertiesManager.getProperty(property);
        if (value == null) {
            throw new KurentoException(exceptionMessage);
        }
        return value;
    }

    public static Address getProperty(String property, Address defaultValue) {
        int port;
        String systemValue = propertyHolder.getProperty(property);
        if (systemValue == null) {
            return defaultValue;
        }
        String[] parts = systemValue.split(":");
        if (parts.length == 0) {
            return defaultValue;
        }
        if (parts.length == 1) {
            return new Address(parts[0], defaultValue.getPort());
        }
        String host = parts[0];
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            port = defaultValue.getPort();
        }
        return new Address(host, port);
    }

    public static int getProperty(String property, int defaultValue) {
        String systemValue = propertyHolder.getProperty(property);
        return systemValue != null ? Integer.parseInt(systemValue) : defaultValue;
    }

    public static String getProperty(String property, String defaultValue) {
        String value = propertyHolder.getProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getProperty(String property, boolean defaultValue) {
        String systemValue = propertyHolder.getProperty(property);
        return systemValue != null ? Boolean.parseBoolean(systemValue) : defaultValue;
    }

    private static String createWithPrefix(String prefix, String property) {
        if (prefix == null) {
            return property;
        }
        return prefix + "." + property;
    }

    public static int getProperty(String prefix, String property, int defaultValue) {
        return PropertiesManager.getProperty(PropertiesManager.createWithPrefix(prefix, property), defaultValue);
    }

    public static String getProperty(String prefix, String property, String defaultValue) {
        return PropertiesManager.getProperty(PropertiesManager.createWithPrefix(prefix, property), defaultValue);
    }

    public static Address getProperty(String prefix, String property, Address defaultValue) {
        return PropertiesManager.getProperty(PropertiesManager.createWithPrefix(prefix, property), defaultValue);
    }

    public static interface PropertyHolder {
        public String getProperty(String var1);
    }
}

