/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kurento.commons.ConfigFileFinder;
import org.kurento.commons.ConfigFilePropertyHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileManager.class);
    private static final String CONFIG_FILE_PATH_PROPERTY = "configFilePath";

    public static void loadConfigFile() {
        ConfigFileManager.loadConfigFile("kurento.conf.json");
    }

    public static void loadConfigFile(String configFileName) {
        try {
            String configFilePath = System.getProperty(CONFIG_FILE_PATH_PROPERTY);
            Path configFile = null;
            configFile = configFilePath != null ? Paths.get(configFilePath, new String[0]) : ConfigFileFinder.searchConfigFileInDefaultPlaces(configFileName);
            if (configFile != null && Files.exists(configFile, new LinkOption[0])) {
                ConfigFilePropertyHolder.configurePropertiesFromConfigFile(configFile);
            } else {
                log.warn("Config file not found. Using all default values");
            }
        }
        catch (IOException e) {
            log.warn("Exception loading config file", (Throwable)e);
        }
    }
}

