/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.kurento.commons.PropertiesManager;

public class ConfigFilePropertyHolder
implements PropertiesManager.PropertyHolder {
    private static final Gson gson = new GsonBuilder().create();
    private JsonObject configFile;

    public static void configurePropertiesFromConfigFile(Path configFilePath) throws JsonSyntaxException, JsonIOException, IOException {
        Preconditions.checkNotNull((Object)configFilePath, (Object)"configFilePath paramter must be not null.");
        JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(configFilePath, StandardCharsets.UTF_8));
        reader.setLenient(true);
        JsonObject configFile = (JsonObject)gson.fromJson(reader, JsonObject.class);
        PropertiesManager.setPropertyHolder(new ConfigFilePropertyHolder(configFile));
    }

    public ConfigFilePropertyHolder(JsonObject configFile) {
        this.configFile = configFile;
    }

    @Override
    public String getProperty(String property) {
        String systemProperty = System.getProperty(property);
        if (systemProperty != null) {
            return systemProperty;
        }
        String[] tokens = property.split("\\.");
        int lastTokenNumber = tokens.length - 1;
        JsonObject currentObject = this.configFile;
        for (int i = 0; i < tokens.length; ++i) {
            JsonElement element = currentObject.get(tokens[i]);
            if (element == null) {
                return null;
            }
            if (i == lastTokenNumber) {
                if (element instanceof JsonPrimitive) {
                    return element.getAsString();
                }
                return element.toString();
            }
            try {
                currentObject = (JsonObject)element;
                continue;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }
}

