/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.kurento.commons.ConfigFilePropertyHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileFinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigFilePropertyHolder.class);
    private static final String DEFAULT_KURENTO_CONF_FILE_NAME = "kurento.conf.json";

    public static Path searchDefaultConfigFile() throws IOException {
        return ConfigFileFinder.searchConfigFileInDefaultPlaces(DEFAULT_KURENTO_CONF_FILE_NAME);
    }

    public static Path searchConfigFileInDefaultPlaces(String configFileName) throws IOException {
        Path path;
        if (configFileName == null) {
            configFileName = DEFAULT_KURENTO_CONF_FILE_NAME;
        }
        if ((path = ConfigFileFinder.getPathFromFile(configFileName)) == null) {
            log.warn("Config file '" + configFileName + "' not found. Searching places are:" + "1) A /config subdir of the current directory." + "2) The current directory." + "3) A classpath /config package." + "4) The classpath root");
            return null;
        }
        return path;
    }

    private static Path getPathFromFile(String fileName) throws IOException {
        Path path = Paths.get("config", fileName);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        path = Paths.get(fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        path = ConfigFileFinder.getPathInClasspath("/config/" + fileName);
        if (path != null) {
            return path;
        }
        path = ConfigFileFinder.getPathInClasspath("/" + fileName);
        if (path != null) {
            return path;
        }
        return null;
    }

    public static Path getPathInClasspath(String resource) throws IOException {
        FileSystem fs;
        URI uri;
        URL url = ConfigFileFinder.class.getResource(resource);
        if (url == null) {
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Exception converting classpath URL to URI", e);
        }
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        try {
            fs = FileSystems.newFileSystem(fileURI, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(fileURI);
        }
        return fs.getPath(entryName, new String[0]);
    }
}

