/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlServiceLoader<P> {
    private static final Logger log = LoggerFactory.getLogger(UrlServiceLoader.class);
    private String urlProperty;
    private String urlProviderProperty;
    private String defaultUrl;
    private String serviceProviderClassName;
    private String url;
    private P serviceProvider;

    public UrlServiceLoader(Path configFile, String urlProperty, String urlProviderProperty, String defaultUrl) {
        this.urlProperty = urlProperty;
        this.urlProviderProperty = urlProviderProperty;
        this.defaultUrl = defaultUrl;
        this.url = this.load(configFile);
    }

    private String load(Path configFile) {
        String kmsUrl = System.getProperty(this.urlProperty);
        if (kmsUrl != null && !kmsUrl.equals("")) {
            return kmsUrl;
        }
        try {
            if (configFile != null && Files.exists(configFile, new LinkOption[0])) {
                Properties properties = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                this.serviceProviderClassName = properties.getProperty(this.urlProviderProperty);
                kmsUrl = properties.getProperty(this.urlProperty);
                if (kmsUrl == null && this.serviceProviderClassName == null) {
                    log.warn("The file {} lacks property '{}' or '{}'. The default kms uri '{}' will be used", new Object[]{configFile.toAbsolutePath().toString(), this.urlProviderProperty, this.urlProperty, this.defaultUrl});
                    return this.defaultUrl;
                }
                return kmsUrl;
            }
            return this.defaultUrl;
        }
        catch (Exception e) {
            log.warn("Exception loading {} file. Returning default kmsUri='{}'", new Object[]{configFile, this.defaultUrl, e});
            return this.defaultUrl;
        }
    }

    protected String getUrl() {
        return this.url;
    }

    private P createUrlProvider() {
        try {
            Class<?> providerClass = Class.forName(this.serviceProviderClassName);
            return (P)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception loading url provider class " + this.serviceProviderClassName, e);
        }
    }

    protected P getServiceProvider() {
        if (this.serviceProvider == null) {
            this.serviceProvider = this.createUrlProvider();
        }
        return this.serviceProvider;
    }
}

