/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlServiceLoader<P> {
    private static final Logger log = LoggerFactory.getLogger(UrlServiceLoader.class);
    private String urlProperty;
    private String urlProviderProperty;
    private String defaultUrl;
    private String serviceProviderClassName;
    private String staticUrl;
    private P serviceProvider;

    public UrlServiceLoader(Path configFile, String urlProperty, String urlProviderProperty, String defaultUrl) {
        this.urlProperty = urlProperty;
        this.urlProviderProperty = urlProviderProperty;
        this.defaultUrl = defaultUrl;
        this.staticUrl = this.load(configFile);
    }

    private String load(Path configFile) {
        String kmsUrlInProperty = System.getProperty(this.urlProperty);
        if (kmsUrlInProperty != null && !kmsUrlInProperty.equals("")) {
            return kmsUrlInProperty;
        }
        try {
            if (configFile != null && Files.exists(configFile, new LinkOption[0])) {
                Properties properties = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                String kmsUrl = properties.getProperty(this.urlProperty);
                if (kmsUrl != null) {
                    log.info("Using static url from property {}={} configured in config file {}", new Object[]{this.urlProperty, kmsUrl, configFile.toAbsolutePath()});
                    return kmsUrl;
                }
                this.serviceProviderClassName = properties.getProperty(this.urlProviderProperty);
                if (this.serviceProviderClassName == null) {
                    log.warn("The file {} lacks property '{}' or '{}'. The default url '{}' will be used", new Object[]{configFile.toAbsolutePath(), this.urlProviderProperty, this.urlProperty, this.defaultUrl});
                    return this.defaultUrl;
                }
                log.info("Using UrlServiceProvider={} configured in config file {}", (Object)this.serviceProviderClassName, (Object)configFile.toAbsolutePath());
                return null;
            }
            log.info("Config file is null (usually this means that config file doesn't exist). Using default url {}", (Object)this.defaultUrl);
            return this.defaultUrl;
        }
        catch (Exception e) {
            log.warn("Exception loading {} file. Returning default kmsUri='{}'", new Object[]{configFile, this.defaultUrl, e});
            return this.defaultUrl;
        }
    }

    protected String getStaticUrl() {
        return this.staticUrl;
    }

    private P createUrlProvider() {
        try {
            Class<?> providerClass = Class.forName(this.serviceProviderClassName);
            return (P)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception loading url provider class " + this.serviceProviderClassName, e);
        }
    }

    protected P getServiceProvider() {
        if (this.serviceProvider == null) {
            this.serviceProvider = this.createUrlProvider();
        }
        return this.serviceProvider;
    }
}

