/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kurento.commons.ClassPath;
import org.kurento.commons.ConfigFilePropertyHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileFinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigFilePropertyHolder.class);
    private static final String DEFAULT_KURENTO_CONF_FILE_NAME = "kurento.conf.json";

    public static Path searchDefaultConfigFile() throws IOException {
        return ConfigFileFinder.searchConfigFileInDefaultPlaces(DEFAULT_KURENTO_CONF_FILE_NAME);
    }

    public static Path searchConfigFileInDefaultPlaces(String configFileName) throws IOException {
        Path path;
        if (configFileName == null) {
            configFileName = DEFAULT_KURENTO_CONF_FILE_NAME;
        }
        if ((path = ConfigFileFinder.getPathFromFile(configFileName)) == null) {
            log.warn("Config file '" + configFileName + "' not found. Searching places are:" + "1) A /config subdir of the current directory." + "2) The current directory." + "3) A classpath /config package." + "4) The classpath root");
            return null;
        }
        return path;
    }

    private static Path getPathFromFile(String fileName) throws IOException {
        Path path = Paths.get("config", fileName);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        path = Paths.get(fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        path = ClassPath.get("/config/" + fileName);
        if (path != null) {
            return path;
        }
        path = ClassPath.get("/" + fileName);
        if (path != null) {
            return path;
        }
        return null;
    }
}

