/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.client.internal;

public abstract class Notification {
    private Method method;

    public Notification(Method method) {
        this.setMethod(method);
    }

    public Notification(String methodValue) {
        this(Method.getFromValue(methodValue));
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.method != null) {
            builder.append("method=").append((Object)this.method);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum Method {
        ICECANDIDATE_METHOD("iceCandidate"),
        MEDIAERROR_METHOD("mediaError"),
        PARTICIPANTJOINED_METHOD("participantJoined"),
        PARTICIPANTLEFT_METHOD("participantLeft"),
        PARTICIPANTEVICTED_METHOD("participantEvicted"),
        PARTICIPANTPUBLISHED_METHOD("participantPublished"),
        PARTICIPANTUNPUBLISHED_METHOD("participantUnpublished"),
        ROOMCLOSED_METHOD("roomClosed"),
        PARTICIPANTSENDMESSAGE_METHOD("sendMessage");

        private String methodValue;

        private Method(String val) {
            this.methodValue = val;
        }

        public String getMethodValue() {
            return this.methodValue;
        }

        public static Method getFromValue(String val) {
            for (Method m : Method.values()) {
                if (!m.methodValue.equals(val)) continue;
                return m;
            }
            return null;
        }

        public String toString() {
            return this.getMethodValue().toString();
        }
    }
}

