/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.kurento.client.IceCandidate;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.room.client.internal.IceCandidateInfo;
import org.kurento.room.client.internal.JsonRoomUtils;
import org.kurento.room.client.internal.MediaErrorInfo;
import org.kurento.room.client.internal.Notification;
import org.kurento.room.client.internal.ParticipantEvictedInfo;
import org.kurento.room.client.internal.ParticipantJoinedInfo;
import org.kurento.room.client.internal.ParticipantLeftInfo;
import org.kurento.room.client.internal.ParticipantPublishedInfo;
import org.kurento.room.client.internal.ParticipantUnpublishedInfo;
import org.kurento.room.client.internal.RoomClosedInfo;
import org.kurento.room.client.internal.SendMessageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJsonRpcHandler
extends DefaultJsonRpcHandler<JsonObject> {
    private static final Logger log = LoggerFactory.getLogger(ServerJsonRpcHandler.class);
    private BlockingQueue<Notification> notifications = new ArrayBlockingQueue<Notification>(100);

    public void handleRequest(Transaction transaction, Request<JsonObject> request) throws Exception {
        Notification notif = null;
        try {
            switch (request.getMethod()) {
                case "iceCandidate": {
                    notif = this.iceCandidate(transaction, request);
                    break;
                }
                case "mediaError": {
                    notif = this.mediaError(transaction, request);
                    break;
                }
                case "participantJoined": {
                    notif = this.participantJoined(transaction, request);
                    break;
                }
                case "participantLeft": {
                    notif = this.participantLeft(transaction, request);
                    break;
                }
                case "participantEvicted": {
                    notif = this.participantEvicted(transaction, request);
                    break;
                }
                case "participantPublished": {
                    notif = this.participantPublished(transaction, request);
                    break;
                }
                case "participantUnpublished": {
                    notif = this.participantUnpublished(transaction, request);
                    break;
                }
                case "roomClosed": {
                    notif = this.roomClosed(transaction, request);
                    break;
                }
                case "sendMessage": {
                    notif = this.participantSendMessage(transaction, request);
                    break;
                }
                default: {
                    throw new Exception("Unrecognized request " + request.getMethod());
                }
            }
        }
        catch (Exception e) {
            log.error("Exception processing request {}", request, (Object)e);
            transaction.sendError((Throwable)e);
            return;
        }
        if (notif != null) {
            try {
                this.notifications.put(notif);
                log.debug("Enqueued notification {}", (Object)notif);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted when enqueuing notification {}", (Object)notif, (Object)e);
            }
        }
    }

    private Notification participantSendMessage(Transaction transaction, Request<JsonObject> request) {
        String room = JsonRoomUtils.getRequestParam(request, "room", String.class);
        String user = JsonRoomUtils.getRequestParam(request, "user", String.class);
        String message = JsonRoomUtils.getRequestParam(request, "message", String.class);
        SendMessageInfo eventInfo = new SendMessageInfo(room, user, message);
        log.debug("Recvd send message event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification roomClosed(Transaction transaction, Request<JsonObject> request) {
        String room = JsonRoomUtils.getRequestParam(request, "room", String.class);
        RoomClosedInfo eventInfo = new RoomClosedInfo(room);
        log.debug("Recvd room closed event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification participantUnpublished(Transaction transaction, Request<JsonObject> request) {
        String name = JsonRoomUtils.getRequestParam(request, "name", String.class);
        ParticipantUnpublishedInfo eventInfo = new ParticipantUnpublishedInfo(name);
        log.debug("Recvd participant unpublished event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification participantPublished(Transaction transaction, Request<JsonObject> request) {
        String id = JsonRoomUtils.getRequestParam(request, "id", String.class);
        JsonArray jsonStreams = JsonRoomUtils.getRequestParam(request, "streams", JsonArray.class);
        Iterator streamIt = jsonStreams.iterator();
        ArrayList<String> streams = new ArrayList<String>();
        while (streamIt.hasNext()) {
            streams.add(JsonRoomUtils.getResponseProperty((JsonElement)streamIt.next(), "id", String.class));
        }
        ParticipantPublishedInfo eventInfo = new ParticipantPublishedInfo(id, streams);
        log.debug("Recvd published event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification participantEvicted(Transaction transaction, Request<JsonObject> request) {
        ParticipantEvictedInfo eventInfo = new ParticipantEvictedInfo();
        log.debug("Recvd participant evicted event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification participantLeft(Transaction transaction, Request<JsonObject> request) {
        String name = JsonRoomUtils.getRequestParam(request, "name", String.class);
        ParticipantLeftInfo eventInfo = new ParticipantLeftInfo(name);
        log.debug("Recvd participant left event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification participantJoined(Transaction transaction, Request<JsonObject> request) {
        String id = JsonRoomUtils.getRequestParam(request, "id", String.class);
        ParticipantJoinedInfo eventInfo = new ParticipantJoinedInfo(id);
        log.debug("Recvd participant joined event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification mediaError(Transaction transaction, Request<JsonObject> request) {
        String description = JsonRoomUtils.getRequestParam(request, "error", String.class);
        MediaErrorInfo eventInfo = new MediaErrorInfo(description);
        log.debug("Recvd media error event {}", (Object)eventInfo);
        return eventInfo;
    }

    private Notification iceCandidate(Transaction transaction, Request<JsonObject> request) {
        String candidate = JsonRoomUtils.getRequestParam(request, "candidate", String.class);
        String sdpMid = JsonRoomUtils.getRequestParam(request, "sdpMid", String.class);
        int sdpMLineIndex = JsonRoomUtils.getRequestParam(request, "sdpMLineIndex", Integer.class);
        IceCandidate iceCandidate = new IceCandidate(candidate, sdpMid, sdpMLineIndex);
        String endpoint = JsonRoomUtils.getRequestParam(request, "endpointName", String.class);
        IceCandidateInfo eventInfo = new IceCandidateInfo(iceCandidate, endpoint);
        log.debug("Recvd ICE candidate event {}", (Object)eventInfo);
        return eventInfo;
    }

    public Notification getNotification() {
        try {
            Notification notif = this.notifications.take();
            log.debug("Dequeued notification {}", (Object)notif);
            return notif;
        }
        catch (InterruptedException e) {
            log.info("Interrupted while polling notifications' queue");
            return null;
        }
    }
}

