/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.client.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.kurento.jsonrpc.message.Request;
import org.kurento.room.exception.RoomException;

public class JsonRoomUtils {
    public static <T> T getRequestParam(Request<JsonObject> request, String paramName, Class<T> type) {
        return JsonRoomUtils.getRequestParam(request, paramName, type, false);
    }

    public static <T> T getRequestParam(Request<JsonObject> request, String paramName, Class<T> type, boolean allowNull) {
        JsonObject params = (JsonObject)request.getParams();
        if (params == null) {
            if (!allowNull) {
                throw new RoomException(RoomException.Code.TRANSPORT_REQUEST_ERROR_CODE, "Invalid request lacking parameter '" + paramName + "'");
            }
            return null;
        }
        return JsonRoomUtils.getConverted(params.get(paramName), paramName, type, allowNull);
    }

    public static <T> T getResponseProperty(JsonElement result, String property, Class<T> type) {
        return JsonRoomUtils.getResponseProperty(result, property, type, false);
    }

    public static <T> T getResponseProperty(JsonElement result, String property, Class<T> type, boolean allowNull) {
        if (!(result instanceof JsonObject)) {
            throw new RoomException(RoomException.Code.TRANSPORT_RESPONSE_ERROR_CODE, "Invalid response format. The response '" + result + "' should be a Json object");
        }
        return JsonRoomUtils.getConverted(result.getAsJsonObject().get(property), property, type, allowNull);
    }

    public static JsonArray getResponseArray(JsonElement result) {
        if (!result.isJsonArray()) {
            throw new RoomException(RoomException.Code.TRANSPORT_RESPONSE_ERROR_CODE, "Invalid response format. The response '" + result + "' should be a Json array");
        }
        return result.getAsJsonArray();
    }

    private static <T> T getConverted(JsonElement paramValue, String property, Class<T> type, boolean allowNull) {
        if (paramValue == null) {
            if (allowNull) {
                return null;
            }
            throw new RoomException(RoomException.Code.TRANSPORT_ERROR_CODE, "Invalid method lacking parameter '" + property + "'");
        }
        if (type == String.class && paramValue.isJsonPrimitive()) {
            return (T)paramValue.getAsString();
        }
        if (type == Integer.class && paramValue.isJsonPrimitive()) {
            return (T)Integer.valueOf(paramValue.getAsInt());
        }
        if (type == JsonArray.class && paramValue.isJsonArray()) {
            return (T)paramValue.getAsJsonArray();
        }
        throw new RoomException(RoomException.Code.TRANSPORT_ERROR_CODE, "Param '" + property + "' with value '" + paramValue + "' is not a " + type.getName());
    }
}

