/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcClientWebSocket;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.kurento.room.client.ServerJsonRpcHandler;
import org.kurento.room.client.internal.JsonRoomUtils;
import org.kurento.room.client.internal.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoRoomClient {
    private static final Logger log = LoggerFactory.getLogger(KurentoRoomClient.class);
    private JsonRpcClient client;
    private ServerJsonRpcHandler handler;

    public KurentoRoomClient(String wsUri) {
        this((JsonRpcClient)new JsonRpcClientWebSocket(wsUri, new JsonRpcWSConnectionListener(){

            public void reconnected(boolean sameServer) {
            }

            public void disconnected() {
                log.warn("JsonRpcWebsocket connection: Disconnected");
            }

            public void connectionFailed() {
                log.warn("JsonRpcWebsocket connection: Connection failed");
            }

            public void connected() {
            }

            public void reconnecting() {
                log.warn("JsonRpcWebsocket connection: is reconnecting");
            }
        }, new SslContextFactory(true)));
    }

    public KurentoRoomClient(JsonRpcClient client) {
        this.client = client;
        this.handler = new ServerJsonRpcHandler();
        this.client.setServerRequestHandler((JsonRpcHandler)this.handler);
    }

    public KurentoRoomClient(JsonRpcClient client, ServerJsonRpcHandler handler) {
        this.client = client;
        this.handler = handler;
        this.client.setServerRequestHandler((JsonRpcHandler)this.handler);
    }

    public void close() throws IOException {
        this.client.close();
    }

    public Map<String, List<String>> joinRoom(String roomName, String userName, Boolean dataChannels) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("room", roomName);
        params.addProperty("user", userName);
        if (dataChannels != null) {
            params.addProperty("dataChannels", dataChannels);
        }
        JsonElement result = this.client.sendRequest("joinRoom", (Object)params);
        HashMap<String, List<String>> peers = new HashMap<String, List<String>>();
        JsonArray jsonPeers = JsonRoomUtils.getResponseProperty(result, "value", JsonArray.class);
        if (jsonPeers.size() > 0) {
            for (JsonElement peer : jsonPeers) {
                String peerId = JsonRoomUtils.getResponseProperty(peer, "id", String.class);
                ArrayList<String> streams = new ArrayList<String>();
                JsonArray jsonStreams = JsonRoomUtils.getResponseProperty(peer, "streams", JsonArray.class, true);
                if (jsonStreams != null) {
                    Iterator streamIt = jsonStreams.iterator();
                    while (streamIt.hasNext()) {
                        streams.add(JsonRoomUtils.getResponseProperty((JsonElement)streamIt.next(), "id", String.class));
                    }
                }
                peers.put(peerId, streams);
            }
        }
        return peers;
    }

    public void leaveRoom() throws IOException {
        this.client.sendRequest("leaveRoom", (Object)new JsonObject());
    }

    public String publishVideo(String sdpOffer, boolean doLoopback) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("sdpOffer", sdpOffer);
        params.addProperty("doLoopback", Boolean.valueOf(doLoopback));
        JsonElement result = this.client.sendRequest("publishVideo", (Object)params);
        return JsonRoomUtils.getResponseProperty(result, "sdpAnswer", String.class);
    }

    public void unpublishVideo() throws IOException {
        this.client.sendRequest("unpublishVideo", (Object)new JsonObject());
    }

    public String receiveVideoFrom(String sender, String sdpOffer) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("sender", sender);
        params.addProperty("sdpOffer", sdpOffer);
        JsonElement result = this.client.sendRequest("receiveVideoFrom", (Object)params);
        return JsonRoomUtils.getResponseProperty(result, "sdpAnswer", String.class);
    }

    public void unsubscribeFromVideo(String sender) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("sender", sender);
        this.client.sendRequest("unsubscribeFromVideo", (Object)params);
    }

    public void onIceCandidate(String endpointName, String candidate, String sdpMid, int sdpMLineIndex) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("endpointName", endpointName);
        params.addProperty("candidate", candidate);
        params.addProperty("sdpMid", sdpMid);
        params.addProperty("sdpMLineIndex", (Number)sdpMLineIndex);
        this.client.sendRequest("onIceCandidate", (Object)params);
    }

    public void sendMessage(String userName, String roomName, String message) throws IOException {
        JsonObject params = new JsonObject();
        params.addProperty("userMessage", userName);
        params.addProperty("roomMessage", roomName);
        params.addProperty("message", message);
        this.client.sendRequest("sendMessage", (Object)params);
    }

    public JsonElement customRequest(JsonObject customReqParams) throws IOException {
        return this.client.sendRequest("customRequest", (Object)customReqParams);
    }

    public Notification getServerNotification() {
        return this.handler.getNotification();
    }
}

