/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.endpoint;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.kurento.client.Continuation;
import org.kurento.client.ErrorEvent;
import org.kurento.client.EventListener;
import org.kurento.client.IceCandidate;
import org.kurento.client.ListenerSubscription;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.exception.KurentoException;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IceWebRtcEndpoint {
    private static Logger log;
    private Participant owner;
    private String endpointName;
    private MediaPipeline pipeline = null;
    protected WebRtcEndpoint endpoint = null;
    private ListenerSubscription endpointSubscription = null;
    private LinkedList<IceCandidate> candidates = new LinkedList();

    public IceWebRtcEndpoint(Participant owner, String endpointName, MediaPipeline pipeline, Logger log) {
        IceWebRtcEndpoint.log = log == null ? LoggerFactory.getLogger(IceWebRtcEndpoint.class) : log;
        this.owner = owner;
        this.setEndpointName(endpointName);
        this.setMediaPipeline(pipeline);
    }

    public Participant getOwner() {
        return this.owner;
    }

    public WebRtcEndpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized WebRtcEndpoint createEndpoint(CountDownLatch endpointLatch) {
        WebRtcEndpoint old = this.endpoint;
        if (this.endpoint == null) {
            this.internalEndpointInitialization(endpointLatch);
        } else {
            endpointLatch.countDown();
        }
        while (!this.candidates.isEmpty()) {
            this.internalAddIceCandidate(this.candidates.removeFirst());
        }
        return old;
    }

    public MediaPipeline getPipeline() {
        return this.pipeline;
    }

    public void setMediaPipeline(MediaPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public synchronized void addIceCandidate(IceCandidate candidate) {
        if (this.endpoint == null) {
            this.candidates.addLast(candidate);
        } else {
            this.internalAddIceCandidate(candidate);
        }
    }

    public synchronized void unregisterErrorListeners() {
        this.unregisterElementErrListener((MediaElement)this.endpoint, this.endpointSubscription);
    }

    protected void internalEndpointInitialization(final CountDownLatch endpointLatch) {
        new WebRtcEndpoint.Builder(this.pipeline).buildAsync((Continuation)new Continuation<WebRtcEndpoint>(){

            public void onSuccess(WebRtcEndpoint result) throws Exception {
                IceWebRtcEndpoint.this.endpoint = result;
                endpointLatch.countDown();
                log.trace("EP {}: Created a new WebRtcEndpoint", (Object)IceWebRtcEndpoint.this.endpointName);
                IceWebRtcEndpoint.this.endpointSubscription = IceWebRtcEndpoint.this.registerElemErrListener((MediaElement)IceWebRtcEndpoint.this.endpoint);
            }

            public void onError(Throwable cause) throws Exception {
                endpointLatch.countDown();
                log.error("EP {}: Failed to create a new WebRtcEndpoint", (Object)IceWebRtcEndpoint.this.endpointName, (Object)cause);
            }
        });
    }

    protected void registerOnIceCandidateEventListener() throws RoomException {
        if (this.endpoint == null) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't register event listener for null WebRtcEndpoint (ep: " + this.endpointName + ")");
        }
        this.endpoint.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

            public void onEvent(OnIceCandidateEvent event) {
                IceWebRtcEndpoint.this.owner.sendIceCandidate(IceWebRtcEndpoint.this.endpointName, event.getCandidate());
            }
        });
    }

    protected ListenerSubscription registerElemErrListener(MediaElement element) {
        return element.addErrorListener((EventListener)new EventListener<ErrorEvent>(){

            public void onEvent(ErrorEvent event) {
                IceWebRtcEndpoint.this.owner.sendMediaError(event);
            }
        });
    }

    protected void unregisterElementErrListener(MediaElement element, ListenerSubscription subscription) {
        if (element == null || subscription == null) {
            return;
        }
        element.removeErrorListener(subscription);
    }

    protected String processOffer(String offer) {
        if (this.endpoint == null) {
            throw new KurentoException("Can't process offer when WebRtcEndpoint is null (ep: " + this.endpointName + ")");
        }
        return this.endpoint.processOffer(offer);
    }

    protected void gatherCandidates() {
        if (this.endpoint == null) {
            throw new KurentoException("Can't start gathering ICE candidates on null WebRtcEndpoint (ep: " + this.endpointName + ")");
        }
        this.endpoint.gatherCandidates((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("EP {}: Internal endpoint started to gather candidates", (Object)IceWebRtcEndpoint.this.endpointName);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Internal endpoint failed to start gathering candidates", (Object)IceWebRtcEndpoint.this.endpointName, (Object)cause);
            }
        });
    }

    private void internalAddIceCandidate(IceCandidate candidate) {
        this.endpoint.addIceCandidate(candidate, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("Ice candidate added to the internal endpoint");
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Failed to add ice candidate to the internal endpoint", (Object)IceWebRtcEndpoint.this.endpointName, (Object)cause);
            }
        });
    }
}

