/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.endpoint;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.kurento.client.Continuation;
import org.kurento.client.ListenerSubscription;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.PassThrough;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.room.endpoint.IceWebRtcEndpoint;
import org.kurento.room.endpoint.MediaShapingEndpoint;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherEndpoint
extends IceWebRtcEndpoint
implements MediaShapingEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PublisherEndpoint.class);
    private PassThrough passThru = null;
    private ListenerSubscription passThruSubscription = null;
    private Map<String, MediaElement> elements = new HashMap<String, MediaElement>();
    private LinkedList<String> elementIds = new LinkedList();
    private boolean connected = false;
    private Map<String, ListenerSubscription> elementsErrorSubscriptions = new HashMap<String, ListenerSubscription>();

    public PublisherEndpoint(Participant owner, String endpointName, MediaPipeline pipeline) {
        super(owner, endpointName, pipeline, log);
    }

    @Override
    protected void internalEndpointInitialization(CountDownLatch endpointLatch) {
        super.internalEndpointInitialization(endpointLatch);
        this.passThru = (PassThrough)new PassThrough.Builder(this.getPipeline()).build();
        this.passThruSubscription = this.registerElemErrListener((MediaElement)this.passThru);
    }

    @Override
    public synchronized void unregisterErrorListeners() {
        super.unregisterErrorListeners();
        this.unregisterElementErrListener((MediaElement)this.passThru, this.passThruSubscription);
        for (String elemId : this.elementIds) {
            this.unregisterElementErrListener(this.elements.get(elemId), this.elementsErrorSubscriptions.remove(elemId));
        }
    }

    public synchronized Collection<MediaElement> getMediaElements() {
        if (this.passThru != null) {
            this.elements.put(this.passThru.getId(), (MediaElement)this.passThru);
        }
        return this.elements.values();
    }

    public synchronized String publish(String sdpOffer, boolean doLoopback) {
        this.registerOnIceCandidateEventListener();
        if (doLoopback) {
            this.connect((MediaElement)this.endpoint);
        }
        String sdpAnswer = this.processOffer(sdpOffer);
        this.gatherCandidates();
        return sdpAnswer;
    }

    public synchronized void connect(MediaElement other) {
        if (!this.connected) {
            this.innerConnect();
        }
        this.internalSinkConnect((MediaElement)this.passThru, other);
    }

    @Override
    public synchronized String apply(MediaElement shaper) throws RoomException {
        String id = shaper.getId();
        if (this.elements.containsKey(id)) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "This endpoint already has a media element with id " + id);
        }
        MediaElement first = null;
        if (!this.elementIds.isEmpty()) {
            first = this.elements.get(this.elementIds.getFirst());
        }
        if (this.connected) {
            if (first != null) {
                this.internalSinkConnect(first, shaper);
            } else {
                this.internalSinkConnect((MediaElement)this.endpoint, shaper);
            }
            this.internalSinkConnect(shaper, (MediaElement)this.passThru);
        }
        this.elementIds.addFirst(id);
        this.elements.put(id, shaper);
        this.elementsErrorSubscriptions.put(id, this.registerElemErrListener(shaper));
        return id;
    }

    @Override
    public synchronized void revert(MediaElement shaper) throws RoomException {
        final String elementId = shaper.getId();
        if (!this.elements.containsKey(elementId)) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "This endpoint (" + this.getEndpointName() + ") has no media element with id " + elementId);
        }
        MediaElement element = this.elements.remove(elementId);
        this.unregisterElementErrListener(element, this.elementsErrorSubscriptions.remove(elementId));
        if (this.connected) {
            String nextId = this.getNext(elementId);
            String prevId = this.getPrevious(elementId);
            Object prev = null;
            Object next = null;
            next = nextId != null ? this.elements.get(nextId) : this.endpoint;
            prev = prevId != null ? this.elements.get(prevId) : this.passThru;
            this.internalSinkConnect((MediaElement)next, (MediaElement)prev);
        }
        this.elementIds.remove(elementId);
        element.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("EP {}: Released media element {}", (Object)PublisherEndpoint.this.getEndpointName(), (Object)elementId);
            }

            public void onError(Throwable cause) throws Exception {
                log.error("EP {}: Failed to release media element {}", new Object[]{PublisherEndpoint.this.getEndpointName(), elementId, cause});
            }
        });
    }

    private String getNext(String uid) {
        int idx = this.elementIds.indexOf(uid);
        if (idx < 0 || idx + 1 == this.elementIds.size()) {
            return null;
        }
        return this.elementIds.get(idx + 1);
    }

    private String getPrevious(String uid) {
        int idx = this.elementIds.indexOf(uid);
        if (idx <= 0) {
            return null;
        }
        return this.elementIds.get(idx - 1);
    }

    private void innerConnect() {
        if (this.endpoint == null) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't connect null WebRtcEndpoint (ep: " + this.getEndpointName() + ")");
        }
        WebRtcEndpoint current = this.endpoint;
        String prevId = this.elementIds.peekLast();
        while (prevId != null) {
            MediaElement prev = this.elements.get(prevId);
            if (prev == null) {
                throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "No media element with id " + prevId + " (ep: " + this.getEndpointName() + ")");
            }
            this.internalSinkConnect((MediaElement)current, prev);
            current = prev;
            prevId = this.getPrevious(prevId);
        }
        this.internalSinkConnect((MediaElement)current, (MediaElement)this.passThru);
        this.connected = true;
    }

    private void internalSinkConnect(MediaElement source, MediaElement sink) {
        source.connect(sink, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("EP {}: Elements have been connected", (Object)PublisherEndpoint.this.getEndpointName());
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Failed to connect media elements", (Object)PublisherEndpoint.this.getEndpointName(), (Object)cause);
            }
        });
    }
}

