/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.kurento.client.IceCandidate;
import org.kurento.room.api.RoomEventHandler;
import org.kurento.room.api.UserNotificationService;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.api.pojo.UserParticipant;
import org.kurento.room.exception.RoomException;

public class DefaultRoomEventHandler
implements RoomEventHandler {
    public static final String PARTICIPANT_LEFT_METHOD = "participantLeft";
    public static final String PARTICIPANT_JOINED_METHOD = "participantJoined";
    public static final String PARTICIPANT_PUBLISHED_METHOD = "participantPublished";
    public static final String PARTICIPANT_UNPUBLISHED_METHOD = "participantUnpublished";
    public static final String PARTICIPANT_SEND_MESSAGE_METHOD = "sendMessage";
    public static final String ROOM_CLOSED_METHOD = "roomClosed";
    public static final String MEDIA_ERROR_METHOD = "mediaError";
    public static final String ICE_CANDIDATE_METHOD = "iceCandidate";
    public static final String ON_ICE_EP_NAME_PARAM = "endpointName";
    public static final String ON_ICE_CANDIDATE_PARAM = "candidate";
    public static final String ON_ICE_SDP_MID_PARAM = "sdpMid";
    public static final String ON_ICE_SDP_M_LINE_INDEX_PARAM = "sdpMLineIndex";
    private UserNotificationService notifService;

    public DefaultRoomEventHandler(UserNotificationService notifService) {
        this.notifService = notifService;
    }

    @Override
    public void onRoomCreated(ParticipantRequest request, String roomName) {
    }

    @Override
    public void onRoomClosed(String roomName, Set<String> participantIds) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("room", roomName);
        for (String pid : participantIds) {
            this.notifService.sendNotification(pid, ROOM_CLOSED_METHOD, notifParams);
        }
    }

    @Override
    public void onParticipantJoined(ParticipantRequest request, String roomName, String newUserName, Set<UserParticipant> existingParticipants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonArray result = new JsonArray();
        for (UserParticipant participant : existingParticipants) {
            JsonObject participantJson = new JsonObject();
            participantJson.addProperty("id", participant.getUserName());
            if (participant.isStreaming()) {
                JsonObject stream = new JsonObject();
                stream.addProperty("id", "webcam");
                JsonArray streamsArray = new JsonArray();
                streamsArray.add((JsonElement)stream);
                participantJson.add("streams", (JsonElement)streamsArray);
            }
            result.add((JsonElement)participantJson);
            JsonObject notifParams = new JsonObject();
            notifParams.addProperty("id", newUserName);
            this.notifService.sendNotification(participant.getParticipantId(), PARTICIPANT_JOINED_METHOD, notifParams);
        }
        this.notifService.sendResponse(request, result);
    }

    @Override
    public void onParticipantLeft(ParticipantRequest request, String roomName, String userName, Set<String> remainingParticipantIds, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject params = new JsonObject();
        params.addProperty("name", userName);
        for (String pid : remainingParticipantIds) {
            this.notifService.sendNotification(pid, PARTICIPANT_LEFT_METHOD, params);
        }
        this.notifService.sendResponse(request, new JsonObject());
        this.notifService.closeSession(request);
    }

    @Override
    public void onPublishMedia(ParticipantRequest request, String publisherName, String sdpAnswer, Set<String> participantIds, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject result = new JsonObject();
        result.addProperty("sdpAnswer", sdpAnswer);
        this.notifService.sendResponse(request, result);
        JsonObject params = new JsonObject();
        params.addProperty("id", publisherName);
        JsonObject stream = new JsonObject();
        stream.addProperty("id", "webcam");
        JsonArray streamsArray = new JsonArray();
        streamsArray.add((JsonElement)stream);
        params.add("streams", (JsonElement)streamsArray);
        for (String pid : participantIds) {
            if (pid.equals(request.getParticipantId())) continue;
            this.notifService.sendNotification(pid, PARTICIPANT_PUBLISHED_METHOD, params);
        }
    }

    @Override
    public void onUnpublishMedia(ParticipantRequest request, String publisherName, Set<String> participantIds, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
        JsonObject params = new JsonObject();
        params.addProperty("name", publisherName);
        for (String pid : participantIds) {
            if (pid.equals(request.getParticipantId())) continue;
            this.notifService.sendNotification(pid, PARTICIPANT_UNPUBLISHED_METHOD, params);
        }
    }

    @Override
    public void onSubscribe(ParticipantRequest request, String sdpAnswer, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject result = new JsonObject();
        result.addProperty("sdpAnswer", sdpAnswer);
        this.notifService.sendResponse(request, result);
    }

    @Override
    public void onUnsubscribe(ParticipantRequest request, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
    }

    @Override
    public void onSendMessage(ParticipantRequest request, String message, String userName, String roomName, Set<String> participantIds, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
        JsonObject params = new JsonObject();
        params.addProperty("room", roomName);
        params.addProperty("user", userName);
        params.addProperty("message", message);
        for (String pid : participantIds) {
            this.notifService.sendNotification(pid, PARTICIPANT_SEND_MESSAGE_METHOD, params);
        }
    }

    @Override
    public void onRecvIceCandidate(ParticipantRequest request, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
    }

    @Override
    public void onSendIceCandidate(String participantId, String endpointName, IceCandidate candidate) {
        JsonObject params = new JsonObject();
        params.addProperty(ON_ICE_EP_NAME_PARAM, endpointName);
        params.addProperty(ON_ICE_SDP_M_LINE_INDEX_PARAM, (Number)candidate.getSdpMLineIndex());
        params.addProperty(ON_ICE_SDP_MID_PARAM, candidate.getSdpMid());
        params.addProperty(ON_ICE_CANDIDATE_PARAM, candidate.getCandidate());
        this.notifService.sendNotification(participantId, ICE_CANDIDATE_METHOD, params);
    }

    @Override
    public void onPipelineError(String roomName, Set<String> participantIds, String description) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("error", description);
        for (String pid : participantIds) {
            this.notifService.sendNotification(pid, MEDIA_ERROR_METHOD, notifParams);
        }
    }

    @Override
    public void onParticipantMediaError(String participantId, String description) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("error", description);
        this.notifService.sendNotification(participantId, MEDIA_ERROR_METHOD, notifParams);
    }
}

