/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.kurento.client.IceCandidate;
import org.kurento.client.KurentoClient;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaType;
import org.kurento.room.api.KurentoClientProvider;
import org.kurento.room.api.KurentoClientSessionInfo;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.api.RoomHandler;
import org.kurento.room.api.pojo.UserParticipant;
import org.kurento.room.endpoint.SdpType;
import org.kurento.room.exception.AdminException;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.kurento.room.internal.Room;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRoomManager {
    private final Logger log = LoggerFactory.getLogger(SyncRoomManager.class);
    private RoomHandler roomHandler;
    private KurentoClientProvider kcProvider;
    private final ConcurrentMap<String, Room> rooms = new ConcurrentHashMap<String, Room>();

    public SyncRoomManager(RoomHandler roomHandler, KurentoClientProvider kcProvider) {
        this.roomHandler = roomHandler;
        this.kcProvider = kcProvider;
    }

    public Set<UserParticipant> joinRoom(String userName, String roomName, boolean webParticipant, String participantId) throws AdminException {
        this.log.debug("Request [JOIN_ROOM] user={}, room={}, web={} ({})", new Object[]{userName, roomName, webParticipant, participantId});
        Room room = (Room)this.rooms.get(roomName);
        if (room == null) {
            this.log.warn("Room '{}' not found");
            throw new AdminException("Room '" + roomName + "' was not found, must be created before '" + userName + "' can join");
        }
        if (room.isClosed()) {
            this.log.warn("'{}' is trying to join room '{}' but it is closing", (Object)userName, (Object)roomName);
            throw new AdminException("'" + userName + "' is trying to join room '" + roomName + "' but it is closing");
        }
        Set<UserParticipant> existingParticipants = this.getParticipants(roomName);
        try {
            room.join(participantId, userName, webParticipant);
            return existingParticipants;
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error joining/creating room {}", new Object[]{userName, roomName, e});
            throw new AdminException("Error on '" + userName + "' to join room '" + roomName + "': " + e.getMessage());
        }
    }

    public Set<UserParticipant> leaveRoom(String participantId) throws AdminException {
        this.log.debug("Request [LEAVE_ROOM] ({})", (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        Room room = participant.getRoom();
        String roomName = room.getName();
        if (room.isClosed()) {
            this.log.warn("'{}' is trying to leave from room '{}' but it is closing", (Object)participant.getName(), (Object)roomName);
            throw new AdminException("'" + participant.getName() + "' is trying to leave from room '" + roomName + "' but it is closing");
        }
        try {
            room.leave(participantId);
            Set<UserParticipant> remainingParticipants = this.getParticipants(roomName);
            if (remainingParticipants.isEmpty()) {
                this.log.debug("No more participants in room '{}', removing it and closing it", (Object)roomName);
                room.close();
                this.rooms.remove(roomName);
                this.log.warn("Room '{}' removed and closed", (Object)roomName);
            }
            return remainingParticipants;
        }
        catch (RoomException e) {
            this.log.warn("Error leaving room", (Throwable)e);
            throw new AdminException("Error on '" + participant.getName() + "' leaving room '" + roomName + "': " + e.getMessage());
        }
    }

    public String publishMedia(String participantId, boolean isOffer, String sdp, MediaElement loopbackAlternativeSrc, MediaType loopbackConnectionType, boolean doLoopback, MediaElement ... mediaElements) throws AdminException {
        this.log.debug("Request [PUBLISH_MEDIA] isOffer={} sdp={} loopbackAltSrc={} lpbkConnType={} doLoopback={} mediaElements={} ({})", new Object[]{isOffer, sdp, loopbackAlternativeSrc == null, loopbackConnectionType, doLoopback, mediaElements, participantId});
        SdpType sdpType = isOffer ? SdpType.OFFER : SdpType.ANSWER;
        Participant participant = this.getParticipant(participantId);
        try {
            String name = participant.getName();
            Room room = participant.getRoom();
            participant.createPublishingEndpoint();
            for (MediaElement elem : mediaElements) {
                participant.getPublisher().apply(elem);
            }
            String sdpResponse = participant.publishToRoom(sdpType, sdp, doLoopback, loopbackAlternativeSrc, loopbackConnectionType);
            if (sdpResponse == null) {
                throw new RoomException(RoomException.Code.SDP_ERROR_CODE, "Error generating SDP response for publishing user " + name);
            }
            room.newPublisher(participant);
            return sdpResponse;
        }
        catch (RoomException e) {
            this.log.warn("Error publishing media of '{}'", (Object)participant.getName(), (Object)e);
            throw new AdminException("Error publishing '" + participant.getName() + "': " + e.getMessage());
        }
    }

    public String publishMedia(String participantId, boolean isOffer, String sdp, boolean doLoopback, MediaElement ... mediaElements) throws AdminException {
        return this.publishMedia(participantId, isOffer, sdp, null, null, doLoopback, mediaElements);
    }

    public String publishMedia(String participantId, boolean isOffer, String sdp, MediaType loopbackConnectionType, boolean doLoopback, MediaElement ... mediaElements) throws AdminException {
        return this.publishMedia(participantId, isOffer, sdp, null, loopbackConnectionType, doLoopback, mediaElements);
    }

    public String generatePublishOffer(String participantId) throws AdminException {
        this.log.debug("Request [GET_PUBLISH_SDP_OFFER] ({})", (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        try {
            String name = participant.getName();
            Room room = participant.getRoom();
            participant.createPublishingEndpoint();
            String sdpOffer = participant.preparePublishConnection();
            if (sdpOffer == null) {
                throw new RoomException(RoomException.Code.SDP_ERROR_CODE, "Error generating SDP offer for publishing user " + name);
            }
            room.newPublisher(participant);
            return sdpOffer;
        }
        catch (RoomException e) {
            this.log.warn("Error generating Sdp offer for publishing media of '{}'", (Object)participant.getName(), (Object)e);
            throw new AdminException("Error generating Sdp offer '" + participant.getName() + "': " + e.getMessage());
        }
    }

    public void unpublishMedia(String participantId) throws AdminException {
        this.log.debug("Request [UNPUBLISH_MEDIA] ({})", (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        try {
            if (!participant.isStreaming()) {
                throw new RoomException(RoomException.Code.USER_NOT_STREAMING_ERROR_CODE, "Participant '" + participant.getName() + "' is not streaming media");
            }
            Room room = participant.getRoom();
            participant.unpublishMedia();
            room.cancelPublisher(participant);
        }
        catch (RoomException e) {
            this.log.warn("Error unpublishing media", (Throwable)e);
            throw new AdminException("Error unpublishing '" + participant.getName() + "': " + e.getMessage());
        }
    }

    public String subscribe(String remoteName, String sdpOffer, String participantId) throws AdminException {
        this.log.debug("Request [SUBSCRIBE] remoteParticipant={} sdpOffer={} ({})", new Object[]{remoteName, sdpOffer, participantId});
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        try {
            Room room = participant.getRoom();
            Participant senderParticipant = room.getParticipantByName(remoteName);
            if (senderParticipant == null) {
                this.log.warn("PARTICIPANT {}: Requesting to recv media from user {} in room {} but user could not be found", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_FOUND_ERROR_CODE, "User '" + remoteName + " not found in room '" + room.getName() + "'");
            }
            if (!senderParticipant.isStreaming()) {
                this.log.warn("PARTICIPANT {}: Requesting to recv media from user {} in room {} but user is not streaming media", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_STREAMING_ERROR_CODE, "User '" + remoteName + " not streaming media in room '" + room.getName() + "'");
            }
            String sdpAnswer = participant.receiveMediaFrom(senderParticipant, sdpOffer);
            if (sdpAnswer == null) {
                throw new RoomException(RoomException.Code.SDP_ERROR_CODE, "Unable to generate SDP answer when subscribing '" + name + "' to '" + remoteName + "'");
            }
            return sdpAnswer;
        }
        catch (RoomException e) {
            this.log.warn("Error subscribing to {}", (Object)remoteName, (Object)e);
            throw new AdminException("Error subscribing '" + name + "' to '" + remoteName + "': " + e.getMessage());
        }
    }

    public void unsubscribe(String remoteName, String participantId) throws AdminException {
        this.log.debug("Request [UNSUBSCRIBE] remoteParticipant={} ({})", (Object)remoteName, (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        try {
            Room room = participant.getRoom();
            Participant senderParticipant = room.getParticipantByName(remoteName);
            if (senderParticipant == null) {
                this.log.warn("PARTICIPANT {}: Requesting to unsubscribe from user {} in room {} but user could not be found", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_FOUND_ERROR_CODE, "User " + remoteName + " not found in room " + room.getName());
            }
            participant.cancelReceivingMedia(remoteName);
        }
        catch (RoomException e) {
            this.log.warn("Error unsubscribing from {}", (Object)remoteName, (Object)e);
            throw new AdminException("Error unsubscribing '" + name + "' from '" + remoteName + "': " + e.getMessage());
        }
    }

    public void onIceCandidate(String endpointName, String candidate, int sdpMLineIndex, String sdpMid, String participantId) throws AdminException {
        this.log.debug("Request [ICE_CANDIDATE] endpoint={} candidate={} sdpMLineIdx={} sdpMid={} ({})", new Object[]{endpointName, candidate, sdpMLineIndex, sdpMid, participantId});
        Participant participant = this.getParticipant(participantId);
        try {
            participant.addIceCandidate(endpointName, new IceCandidate(candidate, sdpMid, sdpMLineIndex));
        }
        catch (RoomException e) {
            this.log.warn("Error receiving ICE candidate", (Throwable)e);
            throw new AdminException("Error receiving ICE candidate '" + candidate + "' for endpoint '" + endpointName + "' of '" + participant.getName() + "': " + e.getMessage());
        }
    }

    public void addMediaElement(String participantId, MediaElement element) throws AdminException {
        this.addMediaElement(participantId, element, null);
    }

    public void addMediaElement(String participantId, MediaElement element, MediaType type) throws AdminException {
        this.log.debug("Add media element {} (connection type: {}) to participant {}", new Object[]{element.getId(), type, participantId});
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        if (participant.isClosed()) {
            throw new AdminException("Participant '" + name + "' has been closed");
        }
        try {
            participant.shapePublisherMedia(element, type);
        }
        catch (RoomException e) {
            throw new AdminException("Error connecting " + (type == null ? "" : type + " ") + "media element - " + e.toString());
        }
    }

    public void removeMediaElement(String participantId, MediaElement element) throws AdminException {
        this.log.debug("Remove media element {} from participant {}", (Object)element.getId(), (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        if (participant.isClosed()) {
            throw new AdminException("Participant '" + name + "' has been closed");
        }
        try {
            participant.getPublisher().revert(element);
        }
        catch (RoomException e) {
            throw new AdminException("Error disconnecting media element - " + e.toString());
        }
    }

    public void mutePublishedMedia(MutedMediaType muteType, String participantId) throws AdminException {
        this.log.debug("Request [MUTE_PUBLISHED] muteType={} ({})", (Object)muteType, (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        if (participant.isClosed()) {
            throw new AdminException("Participant '" + name + "' has been closed");
        }
        if (!participant.isStreaming()) {
            throw new AdminException("Participant '" + name + "' is not streaming media");
        }
        try {
            participant.mutePublishedMedia(muteType);
        }
        catch (RoomException e) {
            throw new AdminException("Error applying mute - " + e.toString());
        }
    }

    public void unmutePublishedMedia(String participantId) throws AdminException {
        this.log.debug("Request [UNMUTE_PUBLISHED] muteType={} ({})", (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        if (participant.isClosed()) {
            throw new AdminException("Participant '" + name + "' has been closed");
        }
        if (!participant.isStreaming()) {
            throw new AdminException("Participant '" + name + "' is not streaming media");
        }
        try {
            participant.unmutePublishedMedia();
        }
        catch (RoomException e) {
            throw new AdminException("Error reverting mute - " + e.toString());
        }
    }

    public void muteSubscribedMedia(String remoteName, MutedMediaType muteType, String participantId) throws AdminException {
        this.log.debug("Request [MUTE_SUBSCRIBED] remoteParticipant={} muteType={} ({})", new Object[]{remoteName, muteType, participantId});
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        try {
            Room room = participant.getRoom();
            Participant senderParticipant = room.getParticipantByName(remoteName);
            if (senderParticipant == null) {
                this.log.warn("PARTICIPANT {}: Requesting to mute streaming from {} in room {} but user could not be found", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_FOUND_ERROR_CODE, "User " + remoteName + " not found in room " + room.getName());
            }
            if (!senderParticipant.isStreaming()) {
                this.log.warn("PARTICIPANT {}: Requesting to mute streaming from {} in room {} but user is not streaming media", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_STREAMING_ERROR_CODE, "User '" + remoteName + " not streaming media in room '" + room.getName() + "'");
            }
            participant.muteSubscribedMedia(senderParticipant, muteType);
        }
        catch (RoomException e) {
            this.log.warn("Error on mute streaming from {}", (Object)remoteName, (Object)e);
            throw new AdminException("Error on mute streaming from '" + remoteName + "': " + e.getMessage());
        }
    }

    public void unmuteSubscribedMedia(String remoteName, String participantId) throws AdminException {
        this.log.debug("Request [UNMUTE_SUBSCRIBED] remoteParticipant={} ({})", (Object)remoteName, (Object)participantId);
        Participant participant = this.getParticipant(participantId);
        String name = participant.getName();
        try {
            Room room = participant.getRoom();
            Participant senderParticipant = room.getParticipantByName(remoteName);
            if (senderParticipant == null) {
                this.log.warn("PARTICIPANT {}: Requesting to unmute streaming from {} in room {} but user could not be found", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_FOUND_ERROR_CODE, "User " + remoteName + " not found in room " + room.getName());
            }
            if (!senderParticipant.isStreaming()) {
                this.log.warn("PARTICIPANT {}: Requesting to unmute streaming from {} in room {} but user is not streaming media", new Object[]{name, remoteName, room.getName()});
                throw new RoomException(RoomException.Code.USER_NOT_STREAMING_ERROR_CODE, "User '" + remoteName + " not streaming media in room '" + room.getName() + "'");
            }
            participant.unmuteSubscribedMedia(senderParticipant);
        }
        catch (RoomException e) {
            this.log.warn("Error on unmute streaming from {}", (Object)remoteName, (Object)e);
            throw new AdminException("Error on unmute streaming from '" + remoteName + "': " + e.getMessage());
        }
    }

    @PreDestroy
    public void close() {
        this.log.info("Closing all rooms");
        for (String roomName : this.rooms.keySet()) {
            try {
                this.closeRoom(roomName);
            }
            catch (Exception e) {
                this.log.warn("Error closing room '{}'", (Object)roomName, (Object)e);
            }
        }
    }

    public Set<String> getRooms() {
        return new HashSet<String>(this.rooms.keySet());
    }

    public Set<UserParticipant> getParticipants(String roomName) throws AdminException {
        Room room = (Room)this.rooms.get(roomName);
        if (room == null) {
            throw new AdminException("Room '" + roomName + "' not found");
        }
        Collection<Participant> participants = room.getParticipants();
        HashSet<UserParticipant> userParts = new HashSet<UserParticipant>();
        for (Participant p : participants) {
            if (p.isClosed()) continue;
            userParts.add(new UserParticipant(p.getId(), p.getName(), p.isStreaming()));
        }
        return userParts;
    }

    public Set<UserParticipant> getPublishers(String roomName) throws AdminException {
        Room r = (Room)this.rooms.get(roomName);
        if (r == null) {
            throw new AdminException("Room '" + roomName + "' not found");
        }
        Collection<Participant> participants = r.getParticipants();
        HashSet<UserParticipant> userParts = new HashSet<UserParticipant>();
        for (Participant p : participants) {
            if (p.isClosed() || !p.isStreaming()) continue;
            userParts.add(new UserParticipant(p.getId(), p.getName(), true));
        }
        return userParts;
    }

    public Set<UserParticipant> getSubscribers(String roomName) throws AdminException {
        Room r = (Room)this.rooms.get(roomName);
        if (r == null) {
            throw new AdminException("Room '" + roomName + "' not found");
        }
        Collection<Participant> participants = r.getParticipants();
        HashSet<UserParticipant> userParts = new HashSet<UserParticipant>();
        for (Participant p : participants) {
            if (p.isClosed() || !p.isSubscribed()) continue;
            userParts.add(new UserParticipant(p.getId(), p.getName(), p.isStreaming()));
        }
        return userParts;
    }

    public Set<UserParticipant> getPeerPublishers(String participantId) throws AdminException {
        Participant participant = this.getParticipant(participantId);
        if (participant == null) {
            throw new AdminException("No participant with id '" + participantId + "' was found");
        }
        Set<String> subscribedEndpoints = participant.getConnectedSubscribedEndpoints();
        Room room = participant.getRoom();
        HashSet<UserParticipant> userParts = new HashSet<UserParticipant>();
        for (String epName : subscribedEndpoints) {
            Participant p = room.getParticipantByName(epName);
            userParts.add(new UserParticipant(p.getId(), p.getName()));
        }
        return userParts;
    }

    public Set<UserParticipant> getPeerSubscribers(String participantId) throws AdminException {
        Participant participant = this.getParticipant(participantId);
        if (participant == null) {
            throw new AdminException("No participant with id '" + participantId + "' was found");
        }
        if (!participant.isStreaming()) {
            throw new AdminException("Participant with id '" + participantId + "' is not a publisher yet");
        }
        HashSet<UserParticipant> userParts = new HashSet<UserParticipant>();
        Room room = participant.getRoom();
        String endpointName = participant.getName();
        for (Participant p : room.getParticipants()) {
            Set<String> subscribedEndpoints;
            if (p.equals(participant) || !(subscribedEndpoints = p.getConnectedSubscribedEndpoints()).contains(endpointName)) continue;
            userParts.add(new UserParticipant(p.getId(), p.getName()));
        }
        return userParts;
    }

    public boolean isPublisherStreaming(String participantId) throws AdminException {
        Participant participant = this.getParticipant(participantId);
        if (participant == null) {
            throw new AdminException("No participant with id '" + participantId + "' was found");
        }
        if (participant.isClosed()) {
            throw new AdminException("Participant '" + participant.getName() + "' has been closed");
        }
        return participant.isStreaming();
    }

    public void createRoom(KurentoClientSessionInfo sessionInfo) throws AdminException {
        String roomName = sessionInfo.getRoomName();
        Room room = (Room)this.rooms.get(sessionInfo);
        if (room != null) {
            throw new AdminException("Room '" + roomName + "' already exists");
        }
        KurentoClient kurentoClient = null;
        try {
            kurentoClient = this.kcProvider.getKurentoClient(sessionInfo);
            room = new Room(roomName, kurentoClient, this.roomHandler);
        }
        catch (RoomException e) {
            this.log.warn("Error creating room {}", (Object)roomName, (Object)e);
            throw new AdminException("Error creating room - " + e.toString());
        }
        Room oldRoom = this.rooms.putIfAbsent(roomName, room);
        if (oldRoom != null) {
            this.log.info("Room '{}' has just been created by another thread");
            throw new AdminException("Room '" + roomName + "' already exists (has just been created by another thread)");
        }
        this.log.warn("No room '{}' exists yet. Created one using KurentoClient '{}')", (Object)roomName, (Object)kurentoClient.getServerManager().getName());
    }

    public void closeRoom(String roomName) throws AdminException {
        Room room = (Room)this.rooms.get(roomName);
        if (room == null) {
            throw new AdminException("Room '" + roomName + "' not found");
        }
        if (room.isClosed()) {
            throw new AdminException("Room '" + roomName + "' already closed");
        }
        HashSet<String> pids = new HashSet<String>(room.getParticipantIds());
        for (String pid : pids) {
            try {
                room.leave(pid);
            }
            catch (RoomException e) {
                this.log.warn("Error evicting participant with id '{}' from room '{}'", new Object[]{pid, roomName, e});
            }
        }
        room.close();
        this.rooms.remove(roomName);
        this.log.warn("Room '{}' removed and closed", (Object)roomName);
    }

    public MediaPipeline getPipeline(String participantId) throws AdminException {
        Participant participant = this.getParticipant(participantId);
        if (participant == null) {
            throw new AdminException("No participant with id '" + participantId + "' was found");
        }
        return participant.getPipeline();
    }

    private Participant getParticipant(String pid) throws AdminException {
        for (Room r : this.rooms.values()) {
            if (r.isClosed() || !r.getParticipantIds().contains(pid) || r.getParticipant(pid) == null) continue;
            return r.getParticipant(pid);
        }
        throw new AdminException("No participant with id '" + pid + "' was found");
    }
}

