/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.endpoint;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.kurento.client.Continuation;
import org.kurento.client.ErrorEvent;
import org.kurento.client.EventListener;
import org.kurento.client.IceCandidate;
import org.kurento.client.ListenerSubscription;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.RtpEndpoint;
import org.kurento.client.SdpEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MediaEndpoint {
    private static Logger log;
    private boolean web = false;
    private WebRtcEndpoint webEndpoint = null;
    private RtpEndpoint endpoint = null;
    private Participant owner;
    private String endpointName;
    private MediaPipeline pipeline = null;
    private ListenerSubscription endpointSubscription = null;
    private LinkedList<IceCandidate> candidates = new LinkedList();
    private MutedMediaType muteType;

    public MediaEndpoint(boolean web, Participant owner, String endpointName, MediaPipeline pipeline, Logger log) {
        MediaEndpoint.log = log == null ? LoggerFactory.getLogger(MediaEndpoint.class) : log;
        this.web = web;
        this.owner = owner;
        this.setEndpointName(endpointName);
        this.setMediaPipeline(pipeline);
    }

    public boolean isWeb() {
        return this.web;
    }

    public Participant getOwner() {
        return this.owner;
    }

    public SdpEndpoint getEndpoint() {
        if (this.isWeb()) {
            return this.webEndpoint;
        }
        return this.endpoint;
    }

    protected WebRtcEndpoint getWebEndpoint() {
        return this.webEndpoint;
    }

    protected RtpEndpoint getRtpEndpoint() {
        return this.endpoint;
    }

    public synchronized SdpEndpoint createEndpoint(CountDownLatch endpointLatch) {
        RtpEndpoint old = this.endpoint;
        if (this.endpoint == null) {
            this.internalEndpointInitialization(endpointLatch);
        } else {
            endpointLatch.countDown();
        }
        if (this.isWeb()) {
            while (!this.candidates.isEmpty()) {
                this.internalAddIceCandidate(this.candidates.removeFirst());
            }
        }
        return old;
    }

    public MediaPipeline getPipeline() {
        return this.pipeline;
    }

    public void setMediaPipeline(MediaPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public synchronized void unregisterErrorListeners() {
        this.unregisterElementErrListener((MediaElement)this.endpoint, this.endpointSubscription);
    }

    public abstract void mute(MutedMediaType var1);

    public abstract void unmute();

    public void setMuteType(MutedMediaType muteType) {
        this.muteType = muteType;
    }

    public MutedMediaType getMuteType() {
        return this.muteType;
    }

    protected void resolveCurrentMuteType(MutedMediaType newMuteType) {
        MutedMediaType prev = this.getMuteType();
        if (prev != null) {
            switch (prev) {
                case AUDIO: {
                    if (!this.muteType.equals((Object)MutedMediaType.VIDEO)) break;
                    this.setMuteType(MutedMediaType.ALL);
                    return;
                }
                case VIDEO: {
                    if (!this.muteType.equals((Object)MutedMediaType.AUDIO)) break;
                    this.setMuteType(MutedMediaType.ALL);
                    return;
                }
                case ALL: {
                    return;
                }
            }
        }
        this.setMuteType(newMuteType);
    }

    protected void internalEndpointInitialization(final CountDownLatch endpointLatch) {
        if (this.isWeb()) {
            new WebRtcEndpoint.Builder(this.pipeline).buildAsync((Continuation)new Continuation<WebRtcEndpoint>(){

                public void onSuccess(WebRtcEndpoint result) throws Exception {
                    MediaEndpoint.this.webEndpoint = result;
                    endpointLatch.countDown();
                    log.trace("EP {}: Created a new WebRtcEndpoint", (Object)MediaEndpoint.this.endpointName);
                    MediaEndpoint.this.endpointSubscription = MediaEndpoint.this.registerElemErrListener((MediaElement)MediaEndpoint.this.webEndpoint);
                }

                public void onError(Throwable cause) throws Exception {
                    endpointLatch.countDown();
                    log.error("EP {}: Failed to create a new WebRtcEndpoint", (Object)MediaEndpoint.this.endpointName, (Object)cause);
                }
            });
        } else {
            new RtpEndpoint.Builder(this.pipeline).buildAsync((Continuation)new Continuation<RtpEndpoint>(){

                public void onSuccess(RtpEndpoint result) throws Exception {
                    MediaEndpoint.this.endpoint = result;
                    endpointLatch.countDown();
                    log.trace("EP {}: Created a new RtpEndpoint", (Object)MediaEndpoint.this.endpointName);
                    MediaEndpoint.this.endpointSubscription = MediaEndpoint.this.registerElemErrListener((MediaElement)MediaEndpoint.this.endpoint);
                }

                public void onError(Throwable cause) throws Exception {
                    endpointLatch.countDown();
                    log.error("EP {}: Failed to create a new RtpEndpoint", (Object)MediaEndpoint.this.endpointName, (Object)cause);
                }
            });
        }
    }

    public synchronized void addIceCandidate(IceCandidate candidate) throws RoomException {
        if (!this.isWeb()) {
            throw new RoomException(RoomException.Code.NOT_WEB_ENDPOINT_ERROR_CODE, "Operation not supported");
        }
        if (this.webEndpoint == null) {
            this.candidates.addLast(candidate);
        } else {
            this.internalAddIceCandidate(candidate);
        }
    }

    protected ListenerSubscription registerElemErrListener(MediaElement element) {
        return element.addErrorListener((EventListener)new EventListener<ErrorEvent>(){

            public void onEvent(ErrorEvent event) {
                MediaEndpoint.this.owner.sendMediaError(event);
            }
        });
    }

    protected void unregisterElementErrListener(MediaElement element, ListenerSubscription subscription) {
        if (element == null || subscription == null) {
            return;
        }
        element.removeErrorListener(subscription);
    }

    protected String processOffer(String offer) throws RoomException {
        if (this.isWeb()) {
            if (this.webEndpoint == null) {
                throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't process offer when WebRtcEndpoint is null (ep: " + this.endpointName + ")");
            }
            return this.webEndpoint.processOffer(offer);
        }
        if (this.endpoint == null) {
            throw new RoomException(RoomException.Code.RTP_ENDPOINT_ERROR_CODE, "Can't process offer when RtpEndpoint is null (ep: " + this.endpointName + ")");
        }
        return this.endpoint.processOffer(offer);
    }

    protected String generateOffer() throws RoomException {
        if (this.isWeb()) {
            if (this.webEndpoint == null) {
                throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't generate offer when WebRtcEndpoint is null (ep: " + this.endpointName + ")");
            }
            return this.webEndpoint.generateOffer();
        }
        if (this.endpoint == null) {
            throw new RoomException(RoomException.Code.RTP_ENDPOINT_ERROR_CODE, "Can't generate offer when RtpEndpoint is null (ep: " + this.endpointName + ")");
        }
        return this.endpoint.generateOffer();
    }

    protected String processAnswer(String answer) throws RoomException {
        if (this.isWeb()) {
            if (this.webEndpoint == null) {
                throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't process answer when WebRtcEndpoint is null (ep: " + this.endpointName + ")");
            }
            return this.webEndpoint.processAnswer(answer);
        }
        if (this.endpoint == null) {
            throw new RoomException(RoomException.Code.RTP_ENDPOINT_ERROR_CODE, "Can't process answer when RtpEndpoint is null (ep: " + this.endpointName + ")");
        }
        return this.endpoint.processAnswer(answer);
    }

    protected void registerOnIceCandidateEventListener() throws RoomException {
        if (!this.isWeb()) {
            return;
        }
        if (this.webEndpoint == null) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't register event listener for null WebRtcEndpoint (ep: " + this.endpointName + ")");
        }
        this.webEndpoint.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

            public void onEvent(OnIceCandidateEvent event) {
                MediaEndpoint.this.owner.sendIceCandidate(MediaEndpoint.this.endpointName, event.getCandidate());
            }
        });
    }

    protected void gatherCandidates() throws RoomException {
        if (!this.isWeb()) {
            return;
        }
        if (this.webEndpoint == null) {
            throw new RoomException(RoomException.Code.WEBRTC_ENDPOINT_ERROR_CODE, "Can't start gathering ICE candidates on null WebRtcEndpoint (ep: " + this.endpointName + ")");
        }
        this.webEndpoint.gatherCandidates((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("EP {}: Internal endpoint started to gather candidates", (Object)MediaEndpoint.this.endpointName);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Internal endpoint failed to start gathering candidates", (Object)MediaEndpoint.this.endpointName, (Object)cause);
            }
        });
    }

    private void internalAddIceCandidate(IceCandidate candidate) {
        this.webEndpoint.addIceCandidate(candidate, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("Ice candidate added to the internal endpoint");
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Failed to add ice candidate to the internal endpoint", (Object)MediaEndpoint.this.endpointName, (Object)cause);
            }
        });
    }
}

