/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room;

import java.util.Set;
import javax.annotation.PreDestroy;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaType;
import org.kurento.room.RoomManager;
import org.kurento.room.api.KurentoClientProvider;
import org.kurento.room.api.KurentoClientSessionInfo;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.api.NotificationRoomHandler;
import org.kurento.room.api.UserNotificationService;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.api.pojo.UserParticipant;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.DefaultKurentoClientSessionInfo;
import org.kurento.room.internal.DefaultNotificationRoomHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationRoomManager {
    private final Logger log = LoggerFactory.getLogger(NotificationRoomManager.class);
    private NotificationRoomHandler notificationRoomHandler;
    private RoomManager internalManager;

    public NotificationRoomManager(UserNotificationService notificationService, KurentoClientProvider kcProvider) {
        this.notificationRoomHandler = new DefaultNotificationRoomHandler(notificationService);
        this.internalManager = new RoomManager(this.notificationRoomHandler, kcProvider);
    }

    public NotificationRoomManager(NotificationRoomHandler notificationRoomHandler, KurentoClientProvider kcProvider) {
        this.notificationRoomHandler = notificationRoomHandler;
        this.internalManager = new RoomManager(notificationRoomHandler, kcProvider);
    }

    public void joinRoom(String userName, String roomName, boolean webParticipant, ParticipantRequest request) {
        Set<UserParticipant> existingParticipants = null;
        try {
            DefaultKurentoClientSessionInfo kcSessionInfo = new DefaultKurentoClientSessionInfo(request.getParticipantId(), roomName);
            existingParticipants = this.internalManager.joinRoom(userName, roomName, webParticipant, kcSessionInfo, request.getParticipantId());
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error joining/creating room {}", new Object[]{userName, roomName, e});
            this.notificationRoomHandler.onParticipantJoined(request, roomName, userName, null, e);
        }
        if (existingParticipants != null) {
            this.notificationRoomHandler.onParticipantJoined(request, roomName, userName, existingParticipants, null);
        }
    }

    public void leaveRoom(ParticipantRequest request) {
        String pid = request.getParticipantId();
        Set<UserParticipant> remainingParticipants = null;
        String roomName = null;
        String userName = null;
        try {
            roomName = this.internalManager.getRoomName(pid);
            userName = this.internalManager.getParticipantName(pid);
            remainingParticipants = this.internalManager.leaveRoom(pid);
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error leaving room {}", new Object[]{userName, roomName, e});
            this.notificationRoomHandler.onParticipantLeft(request, null, null, e);
        }
        if (remainingParticipants != null) {
            this.notificationRoomHandler.onParticipantLeft(request, userName, remainingParticipants, null);
        }
    }

    public void publishMedia(ParticipantRequest request, boolean isOffer, String sdp, MediaElement loopbackAlternativeSrc, MediaType loopbackConnectionType, boolean doLoopback, MediaElement ... mediaElements) {
        String pid = request.getParticipantId();
        String userName = null;
        Set<UserParticipant> participants = null;
        String sdpAnswer = null;
        try {
            userName = this.internalManager.getParticipantName(pid);
            sdpAnswer = this.internalManager.publishMedia(request.getParticipantId(), isOffer, sdp, loopbackAlternativeSrc, loopbackConnectionType, doLoopback, mediaElements);
            participants = this.internalManager.getParticipants(this.internalManager.getRoomName(pid));
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error publishing media", (Object)userName, (Object)e);
            this.notificationRoomHandler.onPublishMedia(request, null, null, null, e);
        }
        if (sdpAnswer != null) {
            this.notificationRoomHandler.onPublishMedia(request, userName, sdpAnswer, participants, null);
        }
    }

    public void publishMedia(ParticipantRequest request, String sdpOffer, boolean doLoopback, MediaElement ... mediaElements) {
        this.publishMedia(request, true, sdpOffer, null, null, doLoopback, mediaElements);
    }

    public void unpublishMedia(ParticipantRequest request) {
        String pid = request.getParticipantId();
        String userName = null;
        Set<UserParticipant> participants = null;
        boolean unpublished = false;
        try {
            userName = this.internalManager.getParticipantName(pid);
            this.internalManager.unpublishMedia(pid);
            unpublished = true;
            participants = this.internalManager.getParticipants(this.internalManager.getRoomName(pid));
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error unpublishing media", (Object)userName, (Object)e);
            this.notificationRoomHandler.onUnpublishMedia(request, null, null, e);
        }
        if (unpublished) {
            this.notificationRoomHandler.onUnpublishMedia(request, userName, participants, null);
        }
    }

    public void subscribe(String remoteName, String sdpOffer, ParticipantRequest request) {
        String pid = request.getParticipantId();
        String userName = null;
        String sdpAnswer = null;
        try {
            userName = this.internalManager.getParticipantName(pid);
            sdpAnswer = this.internalManager.subscribe(remoteName, sdpOffer, pid);
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error subscribing to {}", new Object[]{userName, remoteName, e});
            this.notificationRoomHandler.onSubscribe(request, null, e);
        }
        if (sdpAnswer != null) {
            this.notificationRoomHandler.onSubscribe(request, sdpAnswer, null);
        }
    }

    public void unsubscribe(String remoteName, ParticipantRequest request) {
        String pid = request.getParticipantId();
        String userName = null;
        boolean unsubscribed = false;
        try {
            userName = this.internalManager.getParticipantName(pid);
            this.internalManager.unsubscribe(remoteName, pid);
            unsubscribed = true;
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error unsubscribing from {}", new Object[]{userName, remoteName, e});
            this.notificationRoomHandler.onUnsubscribe(request, e);
        }
        if (unsubscribed) {
            this.notificationRoomHandler.onUnsubscribe(request, null);
        }
    }

    public void onIceCandidate(String endpointName, String candidate, int sdpMLineIndex, String sdpMid, ParticipantRequest request) {
        String pid = request.getParticipantId();
        String userName = null;
        try {
            userName = this.internalManager.getParticipantName(pid);
            this.internalManager.onIceCandidate(endpointName, candidate, sdpMLineIndex, sdpMid, request.getParticipantId());
            this.notificationRoomHandler.onRecvIceCandidate(request, null);
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error receiving ICE candidate (epName={}, candidate={})", new Object[]{userName, endpointName, candidate, e});
            this.notificationRoomHandler.onRecvIceCandidate(request, e);
        }
    }

    public void sendMessage(String message, String userName, String roomName, ParticipantRequest request) {
        this.log.debug("Request [SEND_MESSAGE] message={} ({})", (Object)message, (Object)request);
        try {
            if (!this.internalManager.getParticipantName(request.getParticipantId()).equals(userName)) {
                throw new RoomException(RoomException.Code.USER_NOT_FOUND_ERROR_CODE, "Provided username '" + userName + "' differs from the participant's name");
            }
            if (!this.internalManager.getRoomName(request.getParticipantId()).equals(roomName)) {
                throw new RoomException(RoomException.Code.ROOM_NOT_FOUND_ERROR_CODE, "Provided room name '" + roomName + "' differs from the participant's room");
            }
            this.notificationRoomHandler.onSendMessage(request, message, userName, roomName, this.internalManager.getParticipants(roomName), null);
        }
        catch (RoomException e) {
            this.log.warn("PARTICIPANT {}: Error sending message", (Object)userName, (Object)e);
            this.notificationRoomHandler.onSendMessage(request, null, null, null, null, e);
        }
    }

    @PreDestroy
    public void close() {
        if (!this.internalManager.isClosed()) {
            this.internalManager.close();
        }
    }

    public Set<String> getRooms() {
        return this.internalManager.getRooms();
    }

    public Set<UserParticipant> getParticipants(String roomName) throws RoomException {
        return this.internalManager.getParticipants(roomName);
    }

    public Set<UserParticipant> getPublishers(String roomName) throws RoomException {
        return this.internalManager.getPublishers(roomName);
    }

    public Set<UserParticipant> getSubscribers(String roomName) throws RoomException {
        return this.internalManager.getSubscribers(roomName);
    }

    public Set<UserParticipant> getPeerPublishers(String participantId) throws RoomException {
        return this.internalManager.getPeerPublishers(participantId);
    }

    public Set<UserParticipant> getPeerSubscribers(String participantId) throws RoomException {
        return this.internalManager.getPeerSubscribers(participantId);
    }

    public void createRoom(KurentoClientSessionInfo kcSessionInfo) throws RoomException {
        this.internalManager.createRoom(kcSessionInfo);
    }

    public MediaPipeline getPipeline(String participantId) throws RoomException {
        return this.internalManager.getPipeline(participantId);
    }

    public void evictParticipant(String participantId) throws RoomException {
        UserParticipant participant = this.internalManager.getParticipantInfo(participantId);
        Set<UserParticipant> remainingParticipants = this.internalManager.leaveRoom(participantId);
        this.notificationRoomHandler.onParticipantLeft(participant.getUserName(), remainingParticipants);
        this.notificationRoomHandler.onParticipantEvicted(participant);
    }

    public void closeRoom(String roomName) throws RoomException {
        Set<UserParticipant> participants = this.internalManager.closeRoom(roomName);
        this.notificationRoomHandler.onRoomClosed(roomName, participants);
    }

    public String generatePublishOffer(String participantId) throws RoomException {
        return this.internalManager.generatePublishOffer(participantId);
    }

    public void addMediaElement(String participantId, MediaElement element) throws RoomException {
        this.internalManager.addMediaElement(participantId, element);
    }

    public void addMediaElement(String participantId, MediaElement element, MediaType type) throws RoomException {
        this.internalManager.addMediaElement(participantId, element, type);
    }

    public void removeMediaElement(String participantId, MediaElement element) throws RoomException {
        this.internalManager.removeMediaElement(participantId, element);
    }

    public void mutePublishedMedia(MutedMediaType muteType, String participantId) throws RoomException {
        this.internalManager.mutePublishedMedia(muteType, participantId);
    }

    public void unmutePublishedMedia(String participantId) throws RoomException {
        this.internalManager.unmutePublishedMedia(participantId);
    }

    public void muteSubscribedMedia(String remoteName, MutedMediaType muteType, String participantId) throws RoomException {
        this.internalManager.muteSubscribedMedia(remoteName, muteType, participantId);
    }

    public void unmuteSubscribedMedia(String remoteName, String participantId) throws RoomException {
        this.internalManager.unmuteSubscribedMedia(remoteName, participantId);
    }

    public RoomManager getRoomManager() {
        return this.internalManager;
    }
}

