/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.kurento.client.IceCandidate;
import org.kurento.room.api.NotificationRoomHandler;
import org.kurento.room.api.UserNotificationService;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.api.pojo.UserParticipant;
import org.kurento.room.exception.RoomException;

public class DefaultNotificationRoomHandler
implements NotificationRoomHandler {
    private UserNotificationService notifService;

    public DefaultNotificationRoomHandler(UserNotificationService notifService) {
        this.notifService = notifService;
    }

    @Override
    public void onRoomClosed(String roomName, Set<UserParticipant> participants) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("room", roomName);
        for (UserParticipant participant : participants) {
            this.notifService.sendNotification(participant.getParticipantId(), "roomClosed", notifParams);
        }
    }

    @Override
    public void onParticipantJoined(ParticipantRequest request, String roomName, String newUserName, Set<UserParticipant> existingParticipants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonArray result = new JsonArray();
        for (UserParticipant participant : existingParticipants) {
            JsonObject participantJson = new JsonObject();
            participantJson.addProperty("id", participant.getUserName());
            if (participant.isStreaming()) {
                JsonObject stream = new JsonObject();
                stream.addProperty("id", "webcam");
                JsonArray streamsArray = new JsonArray();
                streamsArray.add((JsonElement)stream);
                participantJson.add("streams", (JsonElement)streamsArray);
            }
            result.add((JsonElement)participantJson);
            JsonObject notifParams = new JsonObject();
            notifParams.addProperty("id", newUserName);
            this.notifService.sendNotification(participant.getParticipantId(), "participantJoined", notifParams);
        }
        this.notifService.sendResponse(request, result);
    }

    @Override
    public void onParticipantLeft(ParticipantRequest request, String userName, Set<UserParticipant> remainingParticipants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject params = new JsonObject();
        params.addProperty("name", userName);
        for (UserParticipant participant : remainingParticipants) {
            this.notifService.sendNotification(participant.getParticipantId(), "participantLeft", params);
        }
        this.notifService.sendResponse(request, new JsonObject());
        this.notifService.closeSession(request);
    }

    @Override
    public void onPublishMedia(ParticipantRequest request, String publisherName, String sdpAnswer, Set<UserParticipant> participants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject result = new JsonObject();
        result.addProperty("sdpAnswer", sdpAnswer);
        this.notifService.sendResponse(request, result);
        JsonObject params = new JsonObject();
        params.addProperty("id", publisherName);
        JsonObject stream = new JsonObject();
        stream.addProperty("id", "webcam");
        JsonArray streamsArray = new JsonArray();
        streamsArray.add((JsonElement)stream);
        params.add("streams", (JsonElement)streamsArray);
        for (UserParticipant participant : participants) {
            if (participant.getParticipantId().equals(request.getParticipantId())) continue;
            this.notifService.sendNotification(participant.getParticipantId(), "participantPublished", params);
        }
    }

    @Override
    public void onUnpublishMedia(ParticipantRequest request, String publisherName, Set<UserParticipant> participants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
        JsonObject params = new JsonObject();
        params.addProperty("name", publisherName);
        for (UserParticipant participant : participants) {
            if (participant.getParticipantId().equals(request.getParticipantId())) continue;
            this.notifService.sendNotification(participant.getParticipantId(), "participantUnpublished", params);
        }
    }

    @Override
    public void onSubscribe(ParticipantRequest request, String sdpAnswer, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        JsonObject result = new JsonObject();
        result.addProperty("sdpAnswer", sdpAnswer);
        this.notifService.sendResponse(request, result);
    }

    @Override
    public void onUnsubscribe(ParticipantRequest request, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
    }

    @Override
    public void onSendMessage(ParticipantRequest request, String message, String userName, String roomName, Set<UserParticipant> participants, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
        JsonObject params = new JsonObject();
        params.addProperty("room", roomName);
        params.addProperty("user", userName);
        params.addProperty("message", message);
        for (UserParticipant participant : participants) {
            this.notifService.sendNotification(participant.getParticipantId(), "sendMessage", params);
        }
    }

    @Override
    public void onRecvIceCandidate(ParticipantRequest request, RoomException error) {
        if (error != null) {
            this.notifService.sendErrorResponse(request, null, error);
            return;
        }
        this.notifService.sendResponse(request, new JsonObject());
    }

    @Override
    public void onParticipantLeft(String userName, Set<UserParticipant> remainingParticipants) {
        JsonObject params = new JsonObject();
        params.addProperty("name", userName);
        for (UserParticipant participant : remainingParticipants) {
            this.notifService.sendNotification(participant.getParticipantId(), "participantLeft", params);
        }
    }

    @Override
    public void onParticipantEvicted(UserParticipant participant) {
        this.notifService.sendNotification(participant.getParticipantId(), "participantEvicted", new JsonObject());
    }

    @Override
    public void onIceCandidate(String roomName, String participantId, String endpointName, IceCandidate candidate) {
        JsonObject params = new JsonObject();
        params.addProperty("endpointName", endpointName);
        params.addProperty("sdpMLineIndex", (Number)candidate.getSdpMLineIndex());
        params.addProperty("sdpMid", candidate.getSdpMid());
        params.addProperty("candidate", candidate.getCandidate());
        this.notifService.sendNotification(participantId, "iceCandidate", params);
    }

    @Override
    public void onPipelineError(String roomName, Set<String> participantIds, String description) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("error", description);
        for (String pid : participantIds) {
            this.notifService.sendNotification(pid, "mediaError", notifParams);
        }
    }

    @Override
    public void onMediaElementError(String roomName, String participantId, String description) {
        JsonObject notifParams = new JsonObject();
        notifParams.addProperty("error", description);
        this.notifService.sendNotification(participantId, "mediaError", notifParams);
    }
}

