/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.endpoint;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.kurento.client.Continuation;
import org.kurento.client.ListenerSubscription;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaType;
import org.kurento.client.PassThrough;
import org.kurento.client.SdpEndpoint;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.endpoint.MediaEndpoint;
import org.kurento.room.endpoint.SdpType;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherEndpoint
extends MediaEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PublisherEndpoint.class);
    private PassThrough passThru = null;
    private ListenerSubscription passThruSubscription = null;
    private Map<String, MediaElement> elements = new HashMap<String, MediaElement>();
    private LinkedList<String> elementIds = new LinkedList();
    private boolean connected = false;
    private Map<String, ListenerSubscription> elementsErrorSubscriptions = new HashMap<String, ListenerSubscription>();

    public PublisherEndpoint(boolean web, boolean dataChannels, Participant owner, String endpointName, MediaPipeline pipeline) {
        super(web, dataChannels, owner, endpointName, pipeline, log);
    }

    @Override
    protected void internalEndpointInitialization(CountDownLatch endpointLatch) {
        super.internalEndpointInitialization(endpointLatch);
        this.passThru = (PassThrough)new PassThrough.Builder(this.getPipeline()).build();
        this.passThruSubscription = this.registerElemErrListener((MediaElement)this.passThru);
    }

    @Override
    public synchronized void unregisterErrorListeners() {
        super.unregisterErrorListeners();
        this.unregisterElementErrListener((MediaElement)this.passThru, this.passThruSubscription);
        for (String elemId : this.elementIds) {
            this.unregisterElementErrListener(this.elements.get(elemId), this.elementsErrorSubscriptions.remove(elemId));
        }
    }

    public synchronized Collection<MediaElement> getMediaElements() {
        if (this.passThru != null) {
            this.elements.put(this.passThru.getId(), (MediaElement)this.passThru);
        }
        return this.elements.values();
    }

    public synchronized String publish(SdpType sdpType, String sdpString, boolean doLoopback, MediaElement loopbackAlternativeSrc, MediaType loopbackConnectionType) {
        this.registerOnIceCandidateEventListener();
        if (doLoopback) {
            if (loopbackAlternativeSrc == null) {
                this.connect((MediaElement)this.getEndpoint(), loopbackConnectionType);
            } else {
                this.connectAltLoopbackSrc(loopbackAlternativeSrc, loopbackConnectionType);
            }
        } else {
            this.innerConnect();
        }
        String sdpResponse = null;
        switch (sdpType) {
            case ANSWER: {
                sdpResponse = this.processAnswer(sdpString);
                break;
            }
            case OFFER: {
                sdpResponse = this.processOffer(sdpString);
                break;
            }
            default: {
                throw new RoomException(RoomException.Code.MEDIA_SDP_ERROR_CODE, "Sdp type not supported: " + (Object)((Object)sdpType));
            }
        }
        this.gatherCandidates();
        return sdpResponse;
    }

    public synchronized String preparePublishConnection() {
        return this.generateOffer();
    }

    public synchronized void connect(MediaElement sink) {
        if (!this.connected) {
            this.innerConnect();
        }
        this.internalSinkConnect((MediaElement)this.passThru, sink);
    }

    public synchronized void connect(MediaElement sink, MediaType type) {
        if (!this.connected) {
            this.innerConnect();
        }
        this.internalSinkConnect((MediaElement)this.passThru, sink, type);
    }

    public synchronized void disconnectFrom(MediaElement sink) {
        this.internalSinkDisconnect((MediaElement)this.passThru, sink);
    }

    public synchronized void disconnectFrom(MediaElement sink, MediaType type) {
        this.internalSinkDisconnect((MediaElement)this.passThru, sink, type);
    }

    public String apply(MediaElement shaper) throws RoomException {
        return this.apply(shaper, null);
    }

    public synchronized String apply(MediaElement shaper, MediaType type) throws RoomException {
        String id = shaper.getId();
        if (id == null) {
            throw new RoomException(RoomException.Code.MEDIA_WEBRTC_ENDPOINT_ERROR_CODE, "Unable to connect media element with null id");
        }
        if (this.elements.containsKey(id)) {
            throw new RoomException(RoomException.Code.MEDIA_WEBRTC_ENDPOINT_ERROR_CODE, "This endpoint already has a media element with id " + id);
        }
        MediaElement first = null;
        if (!this.elementIds.isEmpty()) {
            first = this.elements.get(this.elementIds.getFirst());
        }
        if (this.connected) {
            if (first != null) {
                this.internalSinkConnect(first, shaper, type);
            } else {
                this.internalSinkConnect((MediaElement)this.getEndpoint(), shaper, type);
            }
            this.internalSinkConnect(shaper, (MediaElement)this.passThru, type);
        }
        this.elementIds.addFirst(id);
        this.elements.put(id, shaper);
        this.elementsErrorSubscriptions.put(id, this.registerElemErrListener(shaper));
        return id;
    }

    public synchronized void revert(MediaElement shaper) throws RoomException {
        final String elementId = shaper.getId();
        if (!this.elements.containsKey(elementId)) {
            throw new RoomException(RoomException.Code.MEDIA_ENDPOINT_ERROR_CODE, "This endpoint (" + this.getEndpointName() + ") has no media element with id " + elementId);
        }
        MediaElement element = this.elements.remove(elementId);
        this.unregisterElementErrListener(element, this.elementsErrorSubscriptions.remove(elementId));
        if (this.connected) {
            String nextId = this.getNext(elementId);
            String prevId = this.getPrevious(elementId);
            Object prev = null;
            Object next = null;
            next = nextId != null ? this.elements.get(nextId) : this.getEndpoint();
            prev = prevId != null ? this.elements.get(prevId) : this.passThru;
            this.internalSinkConnect((MediaElement)next, (MediaElement)prev);
        }
        this.elementIds.remove(elementId);
        element.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("EP {}: Released media element {}", (Object)PublisherEndpoint.this.getEndpointName(), (Object)elementId);
            }

            public void onError(Throwable cause) throws Exception {
                log.error("EP {}: Failed to release media element {}", new Object[]{PublisherEndpoint.this.getEndpointName(), elementId, cause});
            }
        });
    }

    @Override
    public synchronized void mute(MutedMediaType muteType) {
        PassThrough sink = this.passThru;
        if (!this.elements.isEmpty()) {
            String sinkId = this.elementIds.peekLast();
            if (!this.elements.containsKey(sinkId)) {
                throw new RoomException(RoomException.Code.MEDIA_ENDPOINT_ERROR_CODE, "This endpoint (" + this.getEndpointName() + ") has no media element with id " + sinkId + " (should've been connected to the internal ep)");
            }
            sink = this.elements.get(sinkId);
        } else {
            log.debug("Will mute connection of WebRTC and PassThrough (no other elems)");
        }
        switch (muteType) {
            case ALL: {
                this.internalSinkDisconnect((MediaElement)this.getEndpoint(), (MediaElement)sink);
                break;
            }
            case AUDIO: {
                this.internalSinkDisconnect((MediaElement)this.getEndpoint(), (MediaElement)sink, MediaType.AUDIO);
                break;
            }
            case VIDEO: {
                this.internalSinkDisconnect((MediaElement)this.getEndpoint(), (MediaElement)sink, MediaType.VIDEO);
            }
        }
        this.resolveCurrentMuteType(muteType);
    }

    @Override
    public synchronized void unmute() {
        PassThrough sink = this.passThru;
        if (!this.elements.isEmpty()) {
            String sinkId = this.elementIds.peekLast();
            if (!this.elements.containsKey(sinkId)) {
                throw new RoomException(RoomException.Code.MEDIA_ENDPOINT_ERROR_CODE, "This endpoint (" + this.getEndpointName() + ") has no media element with id " + sinkId + " (should've been connected to the internal ep)");
            }
            sink = this.elements.get(sinkId);
        } else {
            log.debug("Will unmute connection of WebRTC and PassThrough (no other elems)");
        }
        this.internalSinkConnect((MediaElement)this.getEndpoint(), (MediaElement)sink);
        this.setMuteType(null);
    }

    private String getNext(String uid) {
        int idx = this.elementIds.indexOf(uid);
        if (idx < 0 || idx + 1 == this.elementIds.size()) {
            return null;
        }
        return this.elementIds.get(idx + 1);
    }

    private String getPrevious(String uid) {
        int idx = this.elementIds.indexOf(uid);
        if (idx <= 0) {
            return null;
        }
        return this.elementIds.get(idx - 1);
    }

    private void connectAltLoopbackSrc(MediaElement loopbackAlternativeSrc, MediaType loopbackConnectionType) {
        if (!this.connected) {
            this.innerConnect();
        }
        this.internalSinkConnect(loopbackAlternativeSrc, (MediaElement)this.getEndpoint(), loopbackConnectionType);
    }

    private void innerConnect() {
        if (this.getEndpoint() == null) {
            throw new RoomException(RoomException.Code.MEDIA_ENDPOINT_ERROR_CODE, "Can't connect null endpoint (ep: " + this.getEndpointName() + ")");
        }
        SdpEndpoint current = this.getEndpoint();
        String prevId = this.elementIds.peekLast();
        while (prevId != null) {
            MediaElement prev = this.elements.get(prevId);
            if (prev == null) {
                throw new RoomException(RoomException.Code.MEDIA_ENDPOINT_ERROR_CODE, "No media element with id " + prevId + " (ep: " + this.getEndpointName() + ")");
            }
            this.internalSinkConnect((MediaElement)current, prev);
            current = prev;
            prevId = this.getPrevious(prevId);
        }
        this.internalSinkConnect((MediaElement)current, (MediaElement)this.passThru);
        this.connected = true;
    }

    private void internalSinkConnect(final MediaElement source, final MediaElement sink) {
        source.connect(sink, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.debug("EP {}: Elements have been connected (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), source.getId(), sink.getId()});
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Failed to connect media elements (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), source.getId(), sink.getId(), cause});
            }
        });
    }

    private void internalSinkConnect(final MediaElement source, final MediaElement sink, final MediaType type) {
        if (type == null) {
            this.internalSinkConnect(source, sink);
        } else {
            source.connect(sink, type, (Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.debug("EP {}: {} media elements have been connected (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), type, source.getId(), sink.getId()});
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("EP {}: Failed to connect {} media elements (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), type, source.getId(), sink.getId(), cause});
                }
            });
        }
    }

    private void internalSinkDisconnect(final MediaElement source, final MediaElement sink) {
        source.disconnect(sink, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.debug("EP {}: Elements have been disconnected (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), source.getId(), sink.getId()});
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("EP {}: Failed to disconnect media elements (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), source.getId(), sink.getId(), cause});
            }
        });
    }

    private void internalSinkDisconnect(final MediaElement source, final MediaElement sink, final MediaType type) {
        if (type == null) {
            this.internalSinkDisconnect(source, sink);
        } else {
            source.disconnect(sink, type, (Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.debug("EP {}: {} media elements have been disconnected (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), type, source.getId(), sink.getId()});
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("EP {}: Failed to disconnect {} media elements (source {} -> sink {})", new Object[]{PublisherEndpoint.this.getEndpointName(), type, source.getId(), sink.getId(), cause});
                }
            });
        }
    }
}

