/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.endpoint;

import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaType;
import org.kurento.room.api.MutedMediaType;
import org.kurento.room.endpoint.MediaEndpoint;
import org.kurento.room.endpoint.PublisherEndpoint;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberEndpoint
extends MediaEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SubscriberEndpoint.class);
    private boolean connectedToPublisher = false;
    private PublisherEndpoint publisher = null;

    public SubscriberEndpoint(boolean web, Participant owner, String endpointName, MediaPipeline pipeline) {
        super(web, false, owner, endpointName, pipeline, log);
    }

    public synchronized String subscribe(String sdpOffer, PublisherEndpoint publisher) {
        this.registerOnIceCandidateEventListener();
        String sdpAnswer = this.processOffer(sdpOffer);
        this.gatherCandidates();
        publisher.connect((MediaElement)this.getEndpoint());
        this.setConnectedToPublisher(true);
        this.setPublisher(publisher);
        return sdpAnswer;
    }

    public boolean isConnectedToPublisher() {
        return this.connectedToPublisher;
    }

    public void setConnectedToPublisher(boolean connectedToPublisher) {
        this.connectedToPublisher = connectedToPublisher;
    }

    public PublisherEndpoint getPublisher() {
        return this.publisher;
    }

    public void setPublisher(PublisherEndpoint publisher) {
        this.publisher = publisher;
    }

    @Override
    public synchronized void mute(MutedMediaType muteType) {
        if (this.publisher == null) {
            throw new RoomException(RoomException.Code.MEDIA_MUTE_ERROR_CODE, "Publisher endpoint not found");
        }
        switch (muteType) {
            case ALL: {
                this.publisher.disconnectFrom((MediaElement)this.getEndpoint());
                break;
            }
            case AUDIO: {
                this.publisher.disconnectFrom((MediaElement)this.getEndpoint(), MediaType.AUDIO);
                break;
            }
            case VIDEO: {
                this.publisher.disconnectFrom((MediaElement)this.getEndpoint(), MediaType.VIDEO);
            }
        }
        this.resolveCurrentMuteType(muteType);
    }

    @Override
    public synchronized void unmute() {
        this.publisher.connect((MediaElement)this.getEndpoint());
        this.setMuteType(null);
    }
}

