/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.kms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kurento.client.KurentoClient;
import org.kurento.room.api.KurentoClientProvider;
import org.kurento.room.api.KurentoClientSessionInfo;
import org.kurento.room.exception.RoomException;
import org.kurento.room.internal.DefaultKurentoClientSessionInfo;
import org.kurento.room.kms.Kms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KmsManager
implements KurentoClientProvider {
    private final Logger log = LoggerFactory.getLogger(KmsManager.class);
    private List<Kms> kmss = new ArrayList<Kms>();
    private Iterator<Kms> usageIterator = null;

    public KurentoClient getKurentoClient(KurentoClientSessionInfo sessionInfo) throws RoomException {
        if (!(sessionInfo instanceof DefaultKurentoClientSessionInfo)) {
            throw new RoomException(RoomException.Code.GENERIC_ERROR_CODE, "Unkown session info bean type (expected " + DefaultKurentoClientSessionInfo.class.getName() + ")");
        }
        return this.getKms((DefaultKurentoClientSessionInfo)sessionInfo).getKurentoClient();
    }

    public synchronized Kms getKms(DefaultKurentoClientSessionInfo sessionInfo) {
        if (this.usageIterator == null || !this.usageIterator.hasNext()) {
            this.usageIterator = this.kmss.iterator();
        }
        return this.usageIterator.next();
    }

    public synchronized void addKms(Kms kms) {
        this.kmss.add(kms);
    }

    public synchronized Kms getLessLoadedKms() {
        return Collections.min(this.getKmsLoads()).kms;
    }

    public synchronized Kms getNextLessLoadedKms() {
        List<KmsLoad> sortedLoads = this.getKmssSortedByLoad();
        if (sortedLoads.size() > 1) {
            return sortedLoads.get(1).kms;
        }
        return sortedLoads.get(0).kms;
    }

    public synchronized List<KmsLoad> getKmssSortedByLoad() {
        List<KmsLoad> kmsLoads = this.getKmsLoads();
        Collections.sort(kmsLoads);
        return kmsLoads;
    }

    private List<KmsLoad> getKmsLoads() {
        ArrayList<KmsLoad> kmsLoads = new ArrayList<KmsLoad>();
        for (Kms kms : this.kmss) {
            double load = kms.getLoad();
            kmsLoads.add(new KmsLoad(kms, load));
            this.log.trace("Calc load {} for kms: {}", (Object)load, (Object)kms.getUri());
        }
        return kmsLoads;
    }

    public static class KmsLoad
    implements Comparable<KmsLoad> {
        private Kms kms;
        private double load;

        public KmsLoad(Kms kms, double load) {
            this.kms = kms;
            this.load = load;
        }

        public Kms getKms() {
            return this.kms;
        }

        public double getLoad() {
            return this.load;
        }

        @Override
        public int compareTo(KmsLoad o) {
            return Double.compare(this.load, o.load);
        }
    }
}

