/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room;

import com.google.gson.JsonArray;
import java.util.List;
import org.kurento.commons.PropertiesManager;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.internal.server.config.JsonRpcConfiguration;
import org.kurento.jsonrpc.server.JsonRpcConfigurer;
import org.kurento.jsonrpc.server.JsonRpcHandlerRegistry;
import org.kurento.room.AutodiscoveryKurentoClientProvider;
import org.kurento.room.NotificationRoomManager;
import org.kurento.room.RoomJsonRpcHandler;
import org.kurento.room.api.KurentoClientProvider;
import org.kurento.room.api.UserNotificationService;
import org.kurento.room.kms.FixedOneKmsManager;
import org.kurento.room.rpc.JsonRpcNotificationService;
import org.kurento.room.rpc.JsonRpcUserControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={JsonRpcConfiguration.class})
@SpringBootApplication
public class KurentoRoomServerApp
implements JsonRpcConfigurer {
    public static final String KMSS_URIS_PROPERTY = "kms.uris";
    public static final String KMSS_URIS_DEFAULT = "[ \"ws://localhost:8888/kurento\" ]";
    private static final Logger log = LoggerFactory.getLogger(KurentoRoomServerApp.class);
    private static JsonRpcNotificationService userNotificationService = new JsonRpcNotificationService();

    @Bean
    @ConditionalOnMissingBean
    public KurentoClientProvider kmsManager() {
        JsonArray kmsUris = (JsonArray)PropertiesManager.getPropertyJson((String)KMSS_URIS_PROPERTY, (String)KMSS_URIS_DEFAULT, JsonArray.class);
        List kmsWsUris = JsonUtils.toStringList((JsonArray)kmsUris);
        if (kmsWsUris.isEmpty()) {
            throw new IllegalArgumentException("kms.uris should contain at least one kms url");
        }
        String firstKmsWsUri = (String)kmsWsUris.get(0);
        if (firstKmsWsUri.equals("autodiscovery")) {
            log.info("Using autodiscovery rules to locate KMS on every pipeline");
            return new AutodiscoveryKurentoClientProvider();
        }
        log.info("Configuring Kurento Room Server to use first of the following kmss: " + kmsWsUris);
        return new FixedOneKmsManager(firstKmsWsUri);
    }

    @Bean
    @ConditionalOnMissingBean
    public JsonRpcNotificationService notificationService() {
        return userNotificationService;
    }

    @Bean
    public NotificationRoomManager roomManager() {
        return new NotificationRoomManager((UserNotificationService)userNotificationService, this.kmsManager());
    }

    @Bean
    @ConditionalOnMissingBean
    public JsonRpcUserControl userControl() {
        return new JsonRpcUserControl();
    }

    @Bean
    @ConditionalOnMissingBean
    public RoomJsonRpcHandler roomHandler() {
        return new RoomJsonRpcHandler();
    }

    public void registerJsonRpcHandlers(JsonRpcHandlerRegistry registry) {
        registry.addHandler((JsonRpcHandler)this.roomHandler(), new String[]{"/room"});
    }

    public static void main(String[] args) throws Exception {
        KurentoRoomServerApp.start(args);
    }

    public static ConfigurableApplicationContext start(String[] args) {
        return SpringApplication.run(KurentoRoomServerApp.class, (String[])args);
    }
}

