/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.rpc.JsonRpcNotificationService;
import org.kurento.room.rpc.JsonRpcUserControl;
import org.kurento.room.rpc.ParticipantSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RoomJsonRpcHandler
extends DefaultJsonRpcHandler<JsonObject> {
    private static final Logger log = LoggerFactory.getLogger(RoomJsonRpcHandler.class);
    private static final String HANDLER_THREAD_NAME = "handler";
    @Autowired
    private JsonRpcUserControl userControl;
    @Autowired
    private JsonRpcNotificationService notificationService;

    public List<String> allowedOrigins() {
        return Arrays.asList("*");
    }

    public final void handleRequest(Transaction transaction, Request<JsonObject> request) throws Exception {
        String sessionId = null;
        try {
            sessionId = transaction.getSession().getSessionId();
        }
        catch (Throwable e) {
            log.warn("Error getting session id from transaction {}", (Object)transaction, (Object)e);
            throw e;
        }
        this.updateThreadName("handler_" + sessionId);
        log.debug("Session #{} - request: {}", (Object)sessionId, request);
        this.notificationService.addTransaction(transaction, request);
        ParticipantRequest participantRequest = new ParticipantRequest(sessionId, Integer.toString(request.getId()));
        transaction.startAsync();
        switch (request.getMethod()) {
            case "joinRoom": {
                this.userControl.joinRoom(transaction, request, participantRequest);
                break;
            }
            case "publishVideo": {
                this.userControl.publishVideo(transaction, request, participantRequest);
                break;
            }
            case "unpublishVideo": {
                this.userControl.unpublishVideo(transaction, request, participantRequest);
                break;
            }
            case "receiveVideoFrom": {
                this.userControl.receiveVideoFrom(transaction, request, participantRequest);
                break;
            }
            case "unsubscribeFromVideo": {
                this.userControl.unsubscribeFromVideo(transaction, request, participantRequest);
                break;
            }
            case "onIceCandidate": {
                this.userControl.onIceCandidate(transaction, request, participantRequest);
                break;
            }
            case "leaveRoom": {
                this.userControl.leaveRoom(transaction, request, participantRequest);
                break;
            }
            case "sendMessage": {
                this.userControl.sendMessage(transaction, request, participantRequest);
                break;
            }
            case "customRequest": {
                this.userControl.customRequest(transaction, request, participantRequest);
                break;
            }
            default: {
                log.error("Unrecognized request {}", request);
            }
        }
        this.updateThreadName(HANDLER_THREAD_NAME);
    }

    public final void afterConnectionClosed(Session session, String status) throws Exception {
        ParticipantSession ps = null;
        if (session.getAttributes().containsKey("participant")) {
            ps = (ParticipantSession)session.getAttributes().get("participant");
        }
        String sid = session.getSessionId();
        log.debug("CONN_CLOSED: sessionId={}, participant in session: {}", (Object)sid, (Object)ps);
        ParticipantRequest preq = new ParticipantRequest(sid, null);
        this.updateThreadName(sid + "|wsclosed");
        this.userControl.leaveRoom(null, null, preq);
        this.updateThreadName(HANDLER_THREAD_NAME);
    }

    public void handleTransportError(Session session, Throwable exception) throws Exception {
        log.debug("Transport error for session id {}", (Object)(session != null ? session.getSessionId() : "NULL_SESSION"), (Object)exception);
    }

    private void updateThreadName(String name) {
        Thread.currentThread().setName("user:" + name);
    }
}

