/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.rpc;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionWrapper {
    private static final Logger log = LoggerFactory.getLogger(SessionWrapper.class);
    private Session session;
    private ConcurrentMap<Integer, Transaction> transactions = new ConcurrentHashMap<Integer, Transaction>();

    public SessionWrapper(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTransaction(Integer requestId) {
        return (Transaction)this.transactions.get(requestId);
    }

    public void addTransaction(Integer requestId, Transaction t) {
        Transaction oldT = this.transactions.putIfAbsent(requestId, t);
        if (oldT != null) {
            log.error("Found an existing transaction for the key {}", (Object)requestId);
        }
    }

    public void removeTransaction(Integer requestId) {
        this.transactions.remove(requestId);
    }

    public Collection<Transaction> getTransactions() {
        return this.transactions.values();
    }
}

