/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.kms;

import org.kurento.room.kms.Kms;
import org.kurento.room.kms.LoadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxWebRtcLoadManager
implements LoadManager {
    private static final Logger log = LoggerFactory.getLogger(MaxWebRtcLoadManager.class);
    private int maxWebRtcPerKms;

    public MaxWebRtcLoadManager(int maxWebRtcPerKms) {
        this.maxWebRtcPerKms = maxWebRtcPerKms;
    }

    @Override
    public double calculateLoad(Kms kms) {
        int numWebRtcs = this.countWebRtcEndpoints(kms);
        if (numWebRtcs > this.maxWebRtcPerKms) {
            return 1.0;
        }
        return (double)numWebRtcs / (double)this.maxWebRtcPerKms;
    }

    @Override
    public boolean allowMoreElements(Kms kms) {
        return this.countWebRtcEndpoints(kms) < this.maxWebRtcPerKms;
    }

    private synchronized int countWebRtcEndpoints(Kms kms) {
        try {
            return kms.getKurentoClient().getServerManager().getPipelines().size();
        }
        catch (Throwable e) {
            log.warn("Error counting KurentoClient pipelines", e);
            return 0;
        }
    }
}

