/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.rpc;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.room.api.UserNotificationService;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.exception.RoomException;
import org.kurento.room.rpc.ParticipantSession;
import org.kurento.room.rpc.SessionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcNotificationService
implements UserNotificationService {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcNotificationService.class);
    private static ConcurrentMap<String, SessionWrapper> sessions = new ConcurrentHashMap<String, SessionWrapper>();

    public SessionWrapper addTransaction(Transaction t, Request<JsonObject> request) {
        SessionWrapper oldSw;
        String sessionId = t.getSession().getSessionId();
        SessionWrapper sw = (SessionWrapper)sessions.get(sessionId);
        if (sw == null && (oldSw = sessions.putIfAbsent(sessionId, sw = new SessionWrapper(t.getSession()))) != null) {
            log.warn("Concurrent initialization of session wrapper #{}", (Object)sessionId);
            sw = oldSw;
        }
        sw.addTransaction(request.getId(), t);
        return sw;
    }

    public Session getSession(String sessionId) {
        SessionWrapper sw = (SessionWrapper)sessions.get(sessionId);
        if (sw == null) {
            return null;
        }
        return sw.getSession();
    }

    private Transaction getAndRemoveTransaction(ParticipantRequest participantRequest) {
        Integer tid = null;
        if (participantRequest == null) {
            log.warn("Unable to obtain a transaction for a null ParticipantRequest object");
            return null;
        }
        String tidVal = participantRequest.getRequestId();
        try {
            tid = Integer.parseInt(tidVal);
        }
        catch (NumberFormatException e) {
            log.error("Invalid transaction id, a number was expected but recv: {}", (Object)tidVal, (Object)e);
            return null;
        }
        String sessionId = participantRequest.getParticipantId();
        SessionWrapper sw = (SessionWrapper)sessions.get(sessionId);
        if (sw == null) {
            log.warn("Invalid session id {}", (Object)sessionId);
            return null;
        }
        log.trace("#{} - {} transactions", (Object)sessionId, (Object)sw.getTransactions().size());
        Transaction t = sw.getTransaction(tid);
        sw.removeTransaction(tid);
        return t;
    }

    public void sendResponse(ParticipantRequest participantRequest, Object result) {
        Transaction t = this.getAndRemoveTransaction(participantRequest);
        if (t == null) {
            log.error("No transaction found for {}, unable to send result {}", (Object)participantRequest, result);
            return;
        }
        try {
            t.sendResponse(result);
        }
        catch (Exception e) {
            log.error("Exception responding to user ({})", (Object)participantRequest, (Object)e);
        }
    }

    public void sendErrorResponse(ParticipantRequest participantRequest, Object data, RoomException error) {
        Transaction t = this.getAndRemoveTransaction(participantRequest);
        if (t == null) {
            log.error("No transaction found for {}, unable to send result {}", (Object)participantRequest, data);
            return;
        }
        try {
            String dataVal = data != null ? data.toString() : null;
            t.sendError(error.getCodeValue(), error.getMessage(), dataVal);
        }
        catch (Exception e) {
            log.error("Exception sending error response to user ({})", (Object)participantRequest, (Object)e);
        }
    }

    public void sendNotification(String participantId, String method, Object params) {
        SessionWrapper sw = (SessionWrapper)sessions.get(participantId);
        if (sw == null || sw.getSession() == null) {
            log.error("No session found for id {}, unable to send notification {}: {}", new Object[]{participantId, method, params});
            return;
        }
        Session s = sw.getSession();
        try {
            s.sendNotification(method, params);
        }
        catch (Exception e) {
            log.error("Exception sending notification '{}': {} to user id {}", new Object[]{method, params, participantId, e});
        }
    }

    public void closeSession(ParticipantRequest participantRequest) {
        if (participantRequest == null) {
            log.error("No session found for null ParticipantRequest object, unable to cleanup");
            return;
        }
        String sessionId = participantRequest.getParticipantId();
        SessionWrapper sw = (SessionWrapper)sessions.get(sessionId);
        if (sw == null || sw.getSession() == null) {
            log.error("No session found for id {}, unable to cleanup", (Object)sessionId);
            return;
        }
        Session s = sw.getSession();
        try {
            ParticipantSession ps = null;
            if (s.getAttributes().containsKey("participant")) {
                ps = (ParticipantSession)s.getAttributes().get("participant");
            }
            s.close();
            log.info("Closed session for req {} (userInfo:{})", (Object)participantRequest, (Object)ps);
        }
        catch (IOException e) {
            log.error("Error closing session for req {}", (Object)participantRequest, (Object)e);
        }
        sessions.remove(sessionId);
    }
}

