/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.room.rpc;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.kurento.client.MediaElement;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.room.NotificationRoomManager;
import org.kurento.room.api.pojo.ParticipantRequest;
import org.kurento.room.api.pojo.UserParticipant;
import org.kurento.room.exception.RoomException;
import org.kurento.room.rpc.ParticipantSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JsonRpcUserControl {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcUserControl.class);
    protected NotificationRoomManager roomManager;

    @Autowired
    public JsonRpcUserControl(NotificationRoomManager roomManager) {
        this.roomManager = roomManager;
    }

    public void joinRoom(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) throws IOException, InterruptedException, ExecutionException {
        String roomName = JsonRpcUserControl.getStringParam(request, "room");
        String userName = JsonRpcUserControl.getStringParam(request, "user");
        ParticipantSession participantSession = this.getParticipantSession(transaction);
        participantSession.setParticipantName(userName);
        participantSession.setRoomName(roomName);
        this.roomManager.joinRoom(userName, roomName, true, participantRequest);
    }

    public void publishVideo(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        String sdpOffer = JsonRpcUserControl.getStringParam(request, "sdpOffer");
        boolean doLoopback = JsonRpcUserControl.getBooleanParam(request, "doLoopback");
        this.roomManager.publishMedia(participantRequest, sdpOffer, doLoopback, new MediaElement[0]);
    }

    public void unpublishVideo(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        this.roomManager.unpublishMedia(participantRequest);
    }

    public void receiveVideoFrom(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        String senderName = JsonRpcUserControl.getStringParam(request, "sender");
        senderName = senderName.substring(0, senderName.indexOf("_"));
        String sdpOffer = JsonRpcUserControl.getStringParam(request, "sdpOffer");
        this.roomManager.subscribe(senderName, sdpOffer, participantRequest);
    }

    public void unsubscribeFromVideo(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        String senderName = JsonRpcUserControl.getStringParam(request, "sender");
        senderName = senderName.substring(0, senderName.indexOf("_"));
        this.roomManager.unsubscribe(senderName, participantRequest);
    }

    public void leaveRoomAfterConnClosed(String sessionId) {
        try {
            this.roomManager.evictParticipant(sessionId);
            log.info("Evicted participant with sessionId {}", (Object)sessionId);
        }
        catch (RoomException e) {
            log.warn("Unable to evict: {}", (Object)e.getMessage());
            log.trace("Unable to evict user", (Throwable)e);
        }
    }

    public void leaveRoom(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        boolean exists = false;
        String pid = participantRequest.getParticipantId();
        String roomName = null;
        if (transaction != null) {
            roomName = this.getParticipantSession(transaction).getRoomName();
        }
        if (roomName == null) {
            log.warn("No room information found for participant with session Id {}. Using the admin method to evict the user.", (Object)pid);
            this.leaveRoomAfterConnClosed(pid);
        } else {
            for (UserParticipant part : this.roomManager.getParticipants(roomName)) {
                if (!part.getParticipantId().equals(participantRequest.getParticipantId())) continue;
                exists = true;
                break;
            }
            if (exists) {
                log.debug("Participant with sessionId {} is leaving room {}", (Object)pid, (Object)roomName);
                this.roomManager.leaveRoom(participantRequest);
                log.info("Participant with sessionId {} has left room {}", (Object)pid, (Object)roomName);
            } else {
                log.warn("Participant with session Id {} not found in room {}. Using the admin method to evict the user.", (Object)pid, (Object)roomName);
                this.leaveRoomAfterConnClosed(pid);
            }
        }
    }

    public void onIceCandidate(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        String endpointName = JsonRpcUserControl.getStringParam(request, "endpointName");
        String candidate = JsonRpcUserControl.getStringParam(request, "candidate");
        String sdpMid = JsonRpcUserControl.getStringParam(request, "sdpMid");
        int sdpMLineIndex = JsonRpcUserControl.getIntParam(request, "sdpMLineIndex");
        this.roomManager.onIceCandidate(endpointName, candidate, sdpMLineIndex, sdpMid, participantRequest);
    }

    public void sendMessage(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        String userName = JsonRpcUserControl.getStringParam(request, "userMessage");
        String roomName = JsonRpcUserControl.getStringParam(request, "roomMessage");
        String message = JsonRpcUserControl.getStringParam(request, "message");
        log.debug("Message from {} in room {}: '{}'", new Object[]{userName, roomName, message});
        this.roomManager.sendMessage(message, userName, roomName, participantRequest);
    }

    public void customRequest(Transaction transaction, Request<JsonObject> request, ParticipantRequest participantRequest) {
        throw new RuntimeException("Unsupported method");
    }

    public ParticipantSession getParticipantSession(Transaction transaction) {
        Session session = transaction.getSession();
        ParticipantSession participantSession = (ParticipantSession)session.getAttributes().get("participant");
        if (participantSession == null) {
            participantSession = new ParticipantSession();
            session.getAttributes().put("participant", participantSession);
        }
        return participantSession;
    }

    public static String getStringParam(Request<JsonObject> request, String key) {
        if (request.getParams() == null || ((JsonObject)request.getParams()).get(key) == null) {
            throw new RuntimeException("Request element '" + key + "' is missing");
        }
        return ((JsonObject)request.getParams()).get(key).getAsString();
    }

    public static int getIntParam(Request<JsonObject> request, String key) {
        if (request.getParams() == null || ((JsonObject)request.getParams()).get(key) == null) {
            throw new RuntimeException("Request element '" + key + "' is missing");
        }
        return ((JsonObject)request.getParams()).get(key).getAsInt();
    }

    public static boolean getBooleanParam(Request<JsonObject> request, String key) {
        if (request.getParams() == null || ((JsonObject)request.getParams()).get(key) == null) {
            throw new RuntimeException("Request element '" + key + "' is missing");
        }
        return ((JsonObject)request.getParams()).get(key).getAsBoolean();
    }
}

