/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.ReportFileDialoger;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.ReportPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class ReportLoad
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();

    public Set<String> getActionNames() {
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(ActionEvent e) {
        JFileChooser chooser;
        boolean merging = e.getActionCommand().equals("merge");
        if (!merging) {
            ReportActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "close"));
        }
        if ((chooser = ReportFileDialoger.promptToOpenFile(new String[]{".jmr"})) == null) {
            return;
        }
        boolean isTestPlan = false;
        FileInputStream reader = null;
        File f = null;
        try {
            f = chooser.getSelectedFile();
            if (f != null) {
                if (merging) {
                    log.info("Merging file: " + f);
                } else {
                    log.info("Loading file: " + f);
                    FileServer.getFileServer().setBaseForScript(f);
                }
                reader = new FileInputStream(f);
                HashTree tree = SaveService.loadTree((InputStream)reader);
                isTestPlan = this.insertLoadedTree(e.getID(), tree);
            }
        }
        catch (NoClassDefFoundError ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "Missing jar file - see log for details";
                log.warn("Missing jar file", (Throwable)ex);
            }
            JMeterUtils.reportErrorToUser((String)msg);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "Unexpected error - see log for details";
                log.warn("Unexpected error", (Throwable)ex);
            }
            JMeterUtils.reportErrorToUser((String)msg);
        }
        finally {
            JOrphanUtils.closeQuietly(reader);
            ReportGuiPackage.getInstance().updateCurrentGui();
            ReportGuiPackage.getInstance().getMainFrame().repaint();
        }
        if (!merging && isTestPlan && f != null) {
            ReportGuiPackage.getInstance().setReportPlanFile(f.getAbsolutePath());
        }
    }

    public boolean insertLoadedTree(int id, HashTree tree) throws Exception, IllegalUserActionException {
        if (tree == null) {
            throw new Exception("Error in TestPlan - see log file");
        }
        boolean isTestPlan = tree.getArray()[0] instanceof ReportPlan;
        HashTree newTree = ReportGuiPackage.getInstance().addSubTree(tree);
        ReportGuiPackage.getInstance().updateCurrentGui();
        ReportGuiPackage.getInstance().getMainFrame().getTree().setSelectionPath(new TreePath(((ReportTreeNode)newTree.getArray()[0]).getPath()));
        tree = ReportGuiPackage.getInstance().getCurrentSubTree();
        ReportActionRouter.getInstance().actionPerformed(new ActionEvent(tree.get(tree.getArray()[tree.size() - 1]), id, "sub_tree_loaded"));
        return isTestPlan;
    }

    static {
        commands.add("open");
        commands.add("merge");
    }
}

