/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import java.util.concurrent.ConcurrentHashMap;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.springframework.stereotype.Component;

@Component
public class SessionsManager {
    private final ConcurrentHashMap<String, ServerSession> sessions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ServerSession> sessionsByTransportId = new ConcurrentHashMap();

    public void put(ServerSession session) {
        this.sessions.put(session.getSessionId(), session);
        String transportId = session.getTransportId();
        if (transportId != null) {
            this.sessionsByTransportId.put(transportId, session);
        }
    }

    public ServerSession get(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public ServerSession getByTransportId(String transportId) {
        return this.sessionsByTransportId.get(transportId);
    }

    public ServerSession removeByTransportId(String transportId) {
        ServerSession session = this.sessionsByTransportId.remove(transportId);
        if (session != null) {
            this.sessions.remove(session.getSessionId());
        }
        return session;
    }

    public ServerSession remove(String sessionId) {
        ServerSession session = this.sessions.remove(sessionId);
        if (session != null) {
            this.sessionsByTransportId.remove(session.getTransportId());
        }
        return session;
    }

    public void updateTransportId(ServerSession session, String oldTransportId) {
        if (oldTransportId != null) {
            this.sessionsByTransportId.remove(oldTransportId);
        }
        if (session.getTransportId() != null) {
            this.sessionsByTransportId.put(session.getTransportId(), session);
        }
    }

    public void remove(ServerSession session) {
        this.remove(session.getSessionId());
    }
}

