/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class Arguments
extends ConfigTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    public static final String ARGUMENTS = "Arguments.arguments";

    public Arguments() {
        this.setProperty(new CollectionProperty(ARGUMENTS, new ArrayList()));
    }

    public CollectionProperty getArguments() {
        return (CollectionProperty)this.getProperty(ARGUMENTS);
    }

    @Override
    public void clear() {
        super.clear();
        this.setProperty(new CollectionProperty(ARGUMENTS, new ArrayList()));
    }

    public void setArguments(List<Argument> arguments) {
        this.setProperty(new CollectionProperty(ARGUMENTS, arguments));
    }

    public Map<String, String> getArgumentsAsMap() {
        PropertyIterator iter = this.getArguments().iterator();
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next().getObjectValue();
            if (argMap.containsKey(arg.getName())) continue;
            argMap.put(arg.getName(), arg.getValue());
        }
        return argMap;
    }

    public void addArgument(String name, String value) {
        this.addArgument(new Argument(name, value, null));
    }

    public void addArgument(Argument arg) {
        TestElementProperty newArg = new TestElementProperty(arg.getName(), arg);
        if (this.isRunningVersion()) {
            this.setTemporary(newArg);
        }
        this.getArguments().addItem(newArg);
    }

    public void addArgument(String name, String value, String metadata) {
        this.addArgument(new Argument(name, value, metadata));
    }

    public PropertyIterator iterator() {
        return this.getArguments().iterator();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next().getObjectValue();
            String metaData = arg.getMetaData();
            str.append(arg.getName());
            if (metaData == null) {
                str.append("=");
            } else {
                str.append(metaData);
            }
            str.append(arg.getValue());
            if (!iter.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void removeArgument(int row) {
        if (row < this.getArguments().size()) {
            this.getArguments().remove(row);
        }
    }

    public void removeArgument(Argument arg) {
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next().getObjectValue();
            if (!arg.equals(item)) continue;
            iter.remove();
        }
    }

    public void removeArgument(String argName) {
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next().getObjectValue();
            if (!arg.getName().equals(argName)) continue;
            iter.remove();
        }
    }

    public void removeAllArguments() {
        this.getArguments().clear();
    }

    public void addEmptyArgument() {
        this.addArgument(new Argument("", "", null));
    }

    public int getArgumentCount() {
        return this.getArguments().size();
    }

    public Argument getArgument(int row) {
        Argument argument = null;
        if (row < this.getArguments().size()) {
            argument = (Argument)this.getArguments().get(row).getObjectValue();
        }
        return argument;
    }
}

