/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.format.PatternFormatter;

public class LoggerPanel
extends JPanel
implements LogTarget {
    private static final long serialVersionUID = 6911128494402594429L;
    private JTextArea textArea;
    private final PatternFormatter format;
    private static final int LOGGER_PANEL_MAX_LENGTH = JMeterUtils.getPropDefault("jmeter.loggerpanel.maxlength", 80000);

    public LoggerPanel() {
        this.init();
        this.format = new PatternFormatter("%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}\n");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)areaScrollPane, "Center");
    }

    public void processEvent(final LogEvent logEvent) {
        if (!GuiPackage.getInstance().getMenuItemLoggerPanel().getModel().isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JTextArea jTextArea = LoggerPanel.this.textArea;
                synchronized (jTextArea) {
                    LoggerPanel.this.textArea.append(LoggerPanel.this.format.format(logEvent));
                    int currentLength = LoggerPanel.this.textArea.getText().length();
                    if (LOGGER_PANEL_MAX_LENGTH != 0 && currentLength > LOGGER_PANEL_MAX_LENGTH) {
                        LoggerPanel.this.textArea.setText(LoggerPanel.this.textArea.getText().substring(Math.max(0, currentLength - LOGGER_PANEL_MAX_LENGTH), currentLength));
                    }
                    LoggerPanel.this.textArea.setCaretPosition(LoggerPanel.this.textArea.getText().length());
                }
            }
        });
    }

    public void clear() {
        this.textArea.setText("");
    }
}

