/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.jmeter.util.JMeterUtils;

public class OnErrorPanel
extends JPanel {
    private static final long serialVersionUID = 240L;
    private JRadioButton continueBox;
    private JRadioButton startNextThreadLoopBox;
    private JRadioButton stopThrdBox;
    private JRadioButton stopTestBox;
    private JRadioButton stopTestNowBox;

    private JPanel createOnErrorPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("sampler_on_error_action")));
        ButtonGroup group = new ButtonGroup();
        this.continueBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_continue"));
        group.add(this.continueBox);
        this.continueBox.setSelected(true);
        panel.add(this.continueBox);
        this.startNextThreadLoopBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_start_next_loop"));
        group.add(this.startNextThreadLoopBox);
        panel.add(this.startNextThreadLoopBox);
        this.stopThrdBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_thread"));
        group.add(this.stopThrdBox);
        panel.add(this.stopThrdBox);
        this.stopTestBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test"));
        group.add(this.stopTestBox);
        panel.add(this.stopTestBox);
        this.stopTestNowBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test_now"));
        group.add(this.stopTestNowBox);
        panel.add(this.stopTestNowBox);
        return panel;
    }

    public OnErrorPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        this.add(this.createOnErrorPanel());
    }

    public void configure(int errorAction) {
        this.stopTestNowBox.setSelected(errorAction == 3);
        this.startNextThreadLoopBox.setSelected(errorAction == 4);
        this.stopTestBox.setSelected(errorAction == 2);
        this.stopThrdBox.setSelected(errorAction == 1);
        this.continueBox.setSelected(errorAction == 0);
    }

    public int getOnErrorSetting() {
        if (this.stopTestNowBox.isSelected()) {
            return 3;
        }
        if (this.stopTestBox.isSelected()) {
            return 2;
        }
        if (this.stopThrdBox.isSelected()) {
            return 1;
        }
        if (this.startNextThreadLoopBox.isSelected()) {
            return 4;
        }
        return 0;
    }
}

