/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.LoadRecentProject;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeterMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JMenu fileMenu;
    private JMenuItem file_save_as;
    private JMenuItem file_selection_as;
    private JMenuItem file_revert;
    private JMenuItem file_load;
    private List<JComponent> file_load_recent_files = new LinkedList<JComponent>();
    private JMenuItem file_merge;
    private JMenuItem file_exit;
    private JMenuItem file_close;
    private JMenu editMenu;
    private JMenu edit_add;
    private JMenu runMenu;
    private JMenuItem run_start;
    private JMenuItem run_start_no_timers;
    private JMenu remote_start;
    private JMenuItem remote_start_all;
    private Collection<JMenuItem> remote_engine_start = new LinkedList<JMenuItem>();
    private JMenuItem run_stop;
    private JMenuItem run_shut;
    private JMenu remote_stop;
    private JMenu remote_shut;
    private JMenuItem remote_stop_all;
    private JMenuItem remote_shut_all;
    private Collection<JMenuItem> remote_engine_stop = new LinkedList<JMenuItem>();
    private Collection<JMenuItem> remote_engine_shut = new LinkedList<JMenuItem>();
    private JMenuItem run_clear;
    private JMenuItem run_clearAll;
    private JMenu optionsMenu;
    private JMenu lafMenu;
    private JMenuItem sslManager;
    private JMenu helpMenu;
    private JMenuItem help_about;
    private String[] remoteHosts;
    private JMenu remote_exit;
    private JMenuItem remote_exit_all;
    private Collection<JMenuItem> remote_engine_exit = new LinkedList<JMenuItem>();
    private JMenu searchMenu;
    public static final String SYSTEM_LAF = "System";
    public static final String CROSS_PLATFORM_LAF = "CrossPlatform";

    public JMeterMenuBar() {
        this.remoteHosts = JOrphanUtils.split((String)JMeterUtils.getPropDefault("remote_hosts", ""), (String)",");
        if (this.remoteHosts.length == 1 && this.remoteHosts[0].equals("")) {
            this.remoteHosts = new String[0];
        }
        this.getRemoteItems();
        this.createMenuBar();
        JMeterUtils.addLocaleChangeListener(this);
    }

    public void setFileSaveEnabled(boolean enabled) {
        if (this.file_save_as != null) {
            this.file_save_as.setEnabled(enabled);
        }
    }

    public void setFileLoadEnabled(boolean enabled) {
        if (this.file_load != null) {
            this.file_load.setEnabled(enabled);
        }
        if (this.file_merge != null) {
            this.file_merge.setEnabled(enabled);
        }
    }

    public void setFileRevertEnabled(boolean enabled) {
        if (this.file_revert != null) {
            this.file_revert.setEnabled(enabled);
        }
    }

    public void setProjectFileLoaded(String file) {
        if (this.file_load_recent_files != null && file != null) {
            LoadRecentProject.updateRecentFileMenuItems(this.file_load_recent_files, file);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.editMenu != null) {
            this.editMenu.setEnabled(enabled);
        }
    }

    public void setEditAddMenu(JMenu menu) {
        if (this.edit_add != null) {
            this.editMenu.remove(this.edit_add);
        }
        this.edit_add = menu;
        this.editMenu.insert(this.edit_add, 0);
    }

    public void setEditMenu(JPopupMenu menu) {
        if (menu != null) {
            this.editMenu.removeAll();
            Component[] comps = menu.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.editMenu.add(comps[i]);
            }
            this.editMenu.setEnabled(true);
        } else {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditAddEnabled(boolean enabled) {
        if (this.edit_add != null) {
            this.edit_add.setEnabled(enabled);
        }
        this.setEditEnabled(enabled);
    }

    public void createMenuBar() {
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeRunMenu();
        this.makeOptionsMenu();
        this.makeHelpMenu();
        this.makeSearchMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.searchMenu);
        this.add(this.runMenu);
        this.add(this.optionsMenu);
        this.add(this.helpMenu);
    }

    private void makeHelpMenu() {
        this.helpMenu = JMeterMenuBar.makeMenuRes("help", 72);
        JMenuItem contextHelp = JMeterMenuBar.makeMenuItemRes("help", 72, "help", KeyStrokes.HELP);
        JMenuItem whatClass = JMeterMenuBar.makeMenuItemRes("help_node", 87, "what_class", KeyStrokes.WHAT_CLASS);
        JMenuItem setDebug = JMeterMenuBar.makeMenuItemRes("debug_on", "debug_on", KeyStrokes.DEBUG_ON);
        JMenuItem resetDebug = JMeterMenuBar.makeMenuItemRes("debug_off", "debug_off", KeyStrokes.DEBUG_OFF);
        JMenuItem heapDump = JMeterMenuBar.makeMenuItemRes("heap_dump", "heap_dump");
        this.help_about = JMeterMenuBar.makeMenuItemRes("about", 65, "about");
        this.helpMenu.add(contextHelp);
        this.helpMenu.addSeparator();
        this.helpMenu.add(whatClass);
        this.helpMenu.add(setDebug);
        this.helpMenu.add(resetDebug);
        this.helpMenu.add(heapDump);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.help_about);
    }

    private void makeOptionsMenu() {
        this.optionsMenu = JMeterMenuBar.makeMenuRes("option", 79);
        JMenuItem functionHelper = JMeterMenuBar.makeMenuItemRes("function_dialog_menu_item", 70, "functions", KeyStrokes.FUNCTIONS);
        this.lafMenu = JMeterMenuBar.makeMenuRes("appearance", 76);
        UIManager.LookAndFeelInfo[] lafs = JMeterMenuBar.getAllLAFs();
        for (int i = 0; i < lafs.length; ++i) {
            JMenuItem laf = new JMenuItem(lafs[i].getName());
            laf.addActionListener(ActionRouter.getInstance());
            laf.setActionCommand("laf:" + lafs[i].getClassName());
            laf.setToolTipText(lafs[i].getClassName());
            this.lafMenu.add(laf);
        }
        this.optionsMenu.add(functionHelper);
        this.optionsMenu.add(this.lafMenu);
        JCheckBoxMenuItem menuToolBar = JMeterMenuBar.makeCheckBoxMenuItemRes("menu_toolbar", "toolbar");
        JCheckBoxMenuItem menuLoggerPanel = JMeterMenuBar.makeCheckBoxMenuItemRes("menu_logger_panel", "logger_panel_enable_disable");
        GuiPackage guiInstance = GuiPackage.getInstance();
        if (guiInstance != null) {
            guiInstance.setMenuItemToolbar(menuToolBar);
            guiInstance.setMenuItemLoggerPanel(menuLoggerPanel);
        }
        this.optionsMenu.add(menuToolBar);
        this.optionsMenu.add(menuLoggerPanel);
        if (SSLManager.isSSLSupported()) {
            this.sslManager = JMeterMenuBar.makeMenuItemRes("sslmanager", 83, "sslManager", KeyStrokes.SSL_MANAGER);
            this.optionsMenu.add(this.sslManager);
        }
        this.optionsMenu.add(JMeterMenuBar.makeLanguageMenu());
        JMenuItem collapse = JMeterMenuBar.makeMenuItemRes("menu_collapse_all", "collapse all", KeyStrokes.COLLAPSE_ALL);
        this.optionsMenu.add(collapse);
        JMenuItem expand = JMeterMenuBar.makeMenuItemRes("menu_expand_all", "expand all", KeyStrokes.EXPAND_ALL);
        this.optionsMenu.add(expand);
    }

    public static String[] getLanguages() {
        ArrayList<String> lang = new ArrayList<String>(20);
        lang.add(Locale.ENGLISH.toString());
        lang.add(Locale.FRENCH.toString());
        lang.add(Locale.GERMAN.toString());
        lang.add("no");
        lang.add("pl");
        lang.add("pt_BR");
        lang.add("es");
        lang.add("tr");
        lang.add(Locale.JAPANESE.toString());
        lang.add(Locale.SIMPLIFIED_CHINESE.toString());
        lang.add(Locale.TRADITIONAL_CHINESE.toString());
        String addedLocales = JMeterUtils.getProperty("locales.add");
        if (addedLocales != null) {
            String[] addLanguages;
            for (String newLang : addLanguages = addedLocales.split(",")) {
                log.info("Adding locale " + newLang);
                lang.add(newLang);
            }
        }
        return lang.toArray(new String[lang.size()]);
    }

    static JMenu makeLanguageMenu() {
        JMenu languageMenu = JMeterMenuBar.makeMenuRes("choose_language", 67);
        LangMenuHelper langMenu = new LangMenuHelper(languageMenu);
        for (String lang : JMeterMenuBar.getLanguages()) {
            langMenu.addLang(lang);
        }
        return languageMenu;
    }

    private void makeRunMenu() {
        this.runMenu = JMeterMenuBar.makeMenuRes("run", 82);
        this.run_start = JMeterMenuBar.makeMenuItemRes("start", 83, "start", KeyStrokes.ACTION_START);
        this.run_start_no_timers = JMeterMenuBar.makeMenuItemRes("start_no_timers", "start_no_timers");
        this.run_stop = JMeterMenuBar.makeMenuItemRes("stop", 84, "stop", KeyStrokes.ACTION_STOP);
        this.run_stop.setEnabled(false);
        this.run_shut = JMeterMenuBar.makeMenuItemRes("shutdown", 89, "shutdown", KeyStrokes.ACTION_SHUTDOWN);
        this.run_shut.setEnabled(false);
        this.run_clear = JMeterMenuBar.makeMenuItemRes("clear", 67, "action.clear", KeyStrokes.CLEAR);
        this.run_clearAll = JMeterMenuBar.makeMenuItemRes("clear_all", 97, "action.clear_all", KeyStrokes.CLEAR_ALL);
        this.runMenu.add(this.run_start);
        this.runMenu.add(this.run_start_no_timers);
        if (this.remote_start != null) {
            this.runMenu.add(this.remote_start);
        }
        this.remote_start_all = JMeterMenuBar.makeMenuItemRes("remote_start_all", "remote_start_all", KeyStrokes.REMOTE_START_ALL);
        this.runMenu.add(this.remote_start_all);
        this.runMenu.add(this.run_stop);
        this.runMenu.add(this.run_shut);
        if (this.remote_stop != null) {
            this.runMenu.add(this.remote_stop);
        }
        this.remote_stop_all = JMeterMenuBar.makeMenuItemRes("remote_stop_all", 88, "remote_stop_all", KeyStrokes.REMOTE_STOP_ALL);
        this.runMenu.add(this.remote_stop_all);
        if (this.remote_shut != null) {
            this.runMenu.add(this.remote_shut);
        }
        this.remote_shut_all = JMeterMenuBar.makeMenuItemRes("remote_shut_all", 88, "remote_shut_all", KeyStrokes.REMOTE_SHUT_ALL);
        this.runMenu.add(this.remote_shut_all);
        if (this.remote_exit != null) {
            this.runMenu.add(this.remote_exit);
        }
        this.remote_exit_all = JMeterMenuBar.makeMenuItemRes("remote_exit_all", "remote_exit_all");
        this.runMenu.add(this.remote_exit_all);
        this.runMenu.addSeparator();
        this.runMenu.add(this.run_clear);
        this.runMenu.add(this.run_clearAll);
    }

    private void makeEditMenu() {
        this.editMenu = JMeterMenuBar.makeMenuRes("edit", 69);
        this.editMenu.setEnabled(false);
    }

    private void makeFileMenu() {
        this.fileMenu = JMeterMenuBar.makeMenuRes("file", 70);
        JMenuItem file_save = JMeterMenuBar.makeMenuItemRes("save", 83, "save", KeyStrokes.SAVE);
        file_save.setEnabled(true);
        this.file_save_as = JMeterMenuBar.makeMenuItemRes("save_all_as", 65, "save_all_as", KeyStrokes.SAVE_ALL_AS);
        this.file_save_as.setEnabled(true);
        this.file_selection_as = JMeterMenuBar.makeMenuItemRes("save_as", "save_as");
        this.file_selection_as.setEnabled(true);
        this.file_revert = JMeterMenuBar.makeMenuItemRes("revert_project", 82, "revert_project");
        this.file_revert.setEnabled(false);
        this.file_load = JMeterMenuBar.makeMenuItemRes("menu_open", 79, "open", KeyStrokes.OPEN);
        this.file_load.setEnabled(false);
        this.file_close = JMeterMenuBar.makeMenuItemRes("menu_close", 67, "close", KeyStrokes.CLOSE);
        this.file_exit = JMeterMenuBar.makeMenuItemRes("exit", 88, "exit", KeyStrokes.EXIT);
        this.file_merge = JMeterMenuBar.makeMenuItemRes("menu_merge", 77, "merge");
        this.file_merge.setEnabled(false);
        this.fileMenu.add(this.file_close);
        this.fileMenu.add(this.file_load);
        this.fileMenu.add(this.file_merge);
        this.fileMenu.addSeparator();
        this.fileMenu.add(file_save);
        this.fileMenu.add(this.file_save_as);
        this.fileMenu.add(this.file_selection_as);
        this.fileMenu.add(this.file_revert);
        this.fileMenu.addSeparator();
        this.file_load_recent_files = LoadRecentProject.getRecentFileMenuItems();
        for (JComponent jc : this.file_load_recent_files) {
            this.fileMenu.add(jc);
        }
        this.fileMenu.add(this.file_exit);
    }

    private void makeSearchMenu() {
        this.searchMenu = JMeterMenuBar.makeMenuRes("menu_search");
        JMenuItem search = JMeterMenuBar.makeMenuItemRes("menu_search", 70, "search_tree", KeyStrokes.SEARCH_TREE);
        this.searchMenu.add(search);
        this.searchMenu.setEnabled(true);
        JMenuItem searchReset = JMeterMenuBar.makeMenuItemRes("menu_search_reset", "search_reset");
        this.searchMenu.add(searchReset);
        this.searchMenu.setEnabled(true);
    }

    public void setRunning(boolean running, String host) {
        log.info("setRunning(" + running + "," + host + ")");
        Iterator<JMenuItem> iter = this.remote_engine_start.iterator();
        Iterator<JMenuItem> iter2 = this.remote_engine_stop.iterator();
        Iterator<JMenuItem> iter3 = this.remote_engine_exit.iterator();
        Iterator<JMenuItem> iter4 = this.remote_engine_shut.iterator();
        while (iter.hasNext() && iter2.hasNext() && iter3.hasNext() && iter4.hasNext()) {
            JMenuItem start = iter.next();
            JMenuItem stop = iter2.next();
            JMenuItem exit = iter3.next();
            JMenuItem shut = iter4.next();
            if (start.getText().equals(host)) {
                log.debug("Found start host: " + start.getText());
                start.setEnabled(!running);
            }
            if (stop.getText().equals(host)) {
                log.debug("Found stop  host: " + stop.getText());
                stop.setEnabled(running);
            }
            if (exit.getText().equals(host)) {
                log.debug("Found exit  host: " + exit.getText());
                exit.setEnabled(true);
            }
            if (!shut.getText().equals(host)) continue;
            log.debug("Found exit  host: " + exit.getText());
            shut.setEnabled(running);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.run_start.setEnabled(!enable);
        this.run_start_no_timers.setEnabled(!enable);
        this.run_stop.setEnabled(enable);
        this.run_shut.setEnabled(enable);
    }

    private void getRemoteItems() {
        if (this.remoteHosts.length > 0) {
            this.remote_start = JMeterMenuBar.makeMenuRes("remote_start");
            this.remote_stop = JMeterMenuBar.makeMenuRes("remote_stop");
            this.remote_shut = JMeterMenuBar.makeMenuRes("remote_shut");
            this.remote_exit = JMeterMenuBar.makeMenuRes("remote_exit");
            for (int i = 0; i < this.remoteHosts.length; ++i) {
                this.remoteHosts[i] = this.remoteHosts[i].trim();
                JMenuItem item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_start");
                this.remote_engine_start.add(item);
                this.remote_start.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_stop");
                item.setEnabled(false);
                this.remote_engine_stop.add(item);
                this.remote_stop.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_shut");
                item.setEnabled(false);
                this.remote_engine_shut.add(item);
                this.remote_shut.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_exit");
                item.setEnabled(false);
                this.remote_engine_exit.add(item);
                this.remote_exit.add(item);
            }
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.updateMenuElement(this.fileMenu);
        this.updateMenuElement(this.editMenu);
        this.updateMenuElement(this.searchMenu);
        this.updateMenuElement(this.runMenu);
        this.updateMenuElement(this.optionsMenu);
        this.updateMenuElement(this.helpMenu);
    }

    public static UIManager.LookAndFeelInfo[] getAllLAFs() {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        int i = lafs.length;
        UIManager.LookAndFeelInfo[] lafsAll = new UIManager.LookAndFeelInfo[i + 2];
        System.arraycopy(lafs, 0, lafsAll, 0, i);
        lafsAll[i++] = new UIManager.LookAndFeelInfo(CROSS_PLATFORM_LAF, UIManager.getCrossPlatformLookAndFeelClassName());
        lafsAll[i++] = new UIManager.LookAndFeelInfo(SYSTEM_LAF, UIManager.getSystemLookAndFeelClassName());
        return lafsAll;
    }

    private void updateMenuElement(MenuElement menu) {
        Component component = menu.getComponent();
        String compName = component.getName();
        if (compName != null) {
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                if (JMeterMenuBar.isResource(jMenu.getActionCommand())) {
                    jMenu.setText(JMeterUtils.getResString(compName));
                }
            } else {
                JMenuItem jMenuItem = (JMenuItem)component;
                if (JMeterMenuBar.isResource(jMenuItem.getActionCommand())) {
                    jMenuItem.setText(JMeterUtils.getResString(compName));
                } else if ("change_language".equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setText(JMeterUtils.getLocaleString(compName));
                }
            }
        }
        MenuElement[] subelements = menu.getSubElements();
        for (int i = 0; i < subelements.length; ++i) {
            this.updateMenuElement(subelements[i]);
        }
    }

    private static boolean isResource(String actionCommand) {
        if ("change_language".equals(actionCommand)) {
            return false;
        }
        if ("Add".equals(actionCommand)) {
            return false;
        }
        if ("remote_start".equals(actionCommand)) {
            return false;
        }
        if ("remote_stop".equals(actionCommand)) {
            return false;
        }
        if ("remote_shut".equals(actionCommand)) {
            return false;
        }
        if ("remote_exit".equals(actionCommand)) {
            return false;
        }
        if ("open_recent".equals(actionCommand)) {
            return false;
        }
        return actionCommand == null || !actionCommand.startsWith("laf:");
    }

    private static JMenu makeMenuRes(String resource) {
        JMenu menu = new JMenu(JMeterUtils.getResString(resource));
        menu.setName(resource);
        return menu;
    }

    private static JMenu makeMenuRes(String resource, int mnemonic) {
        JMenu menu = JMeterMenuBar.makeMenuRes(resource);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    private static JMenuItem makeMenuItemNoRes(String label, String actionCommand) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setName(label);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(ActionRouter.getInstance());
        return menuItem;
    }

    private static JMenuItem makeMenuItemRes(String resource, String actionCommand) {
        return JMeterMenuBar.makeMenuItemRes(resource, 0, actionCommand, null);
    }

    private static JMenuItem makeMenuItemRes(String resource, String actionCommand, KeyStroke keyStroke) {
        return JMeterMenuBar.makeMenuItemRes(resource, 0, actionCommand, keyStroke);
    }

    private static JMenuItem makeMenuItemRes(String resource, int mnemonic, String actionCommand) {
        return JMeterMenuBar.makeMenuItemRes(resource, mnemonic, actionCommand, null);
    }

    private static JMenuItem makeMenuItemRes(String resource, int mnemonic, String actionCommand, KeyStroke keyStroke) {
        JMenuItem menuItem = new JMenuItem(JMeterUtils.getResString(resource), mnemonic);
        menuItem.setName(resource);
        menuItem.setActionCommand(actionCommand);
        menuItem.setAccelerator(keyStroke);
        menuItem.addActionListener(ActionRouter.getInstance());
        return menuItem;
    }

    private static JCheckBoxMenuItem makeCheckBoxMenuItemRes(String resource, String actionCommand) {
        return JMeterMenuBar.makeCheckBoxMenuItemRes(resource, actionCommand, null);
    }

    private static JCheckBoxMenuItem makeCheckBoxMenuItemRes(String resource, String actionCommand, KeyStroke keyStroke) {
        JCheckBoxMenuItem cbkMenuItem = new JCheckBoxMenuItem(JMeterUtils.getResString(resource));
        cbkMenuItem.setName(resource);
        cbkMenuItem.setActionCommand(actionCommand);
        cbkMenuItem.setAccelerator(keyStroke);
        cbkMenuItem.addActionListener(ActionRouter.getInstance());
        return cbkMenuItem;
    }

    private static class LangMenuHelper {
        final ActionRouter actionRouter = ActionRouter.getInstance();
        final JMenu languageMenu;

        LangMenuHelper(JMenu _languageMenu) {
            this.languageMenu = _languageMenu;
        }

        void addLang(String locale) {
            String localeString = JMeterUtils.getLocaleString(locale);
            JMenuItem language = new JMenuItem(localeString);
            language.addActionListener(this.actionRouter);
            language.setActionCommand("change_language");
            language.setName(locale);
            this.languageMenu.add(language);
        }
    }
}

