/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public final class OldSaveService {
    private static final Logger log = LoggingManager.getLoggerForClass();
    static final String PRESERVE = "preserve";
    static final String XML_SPACE = "xml:space";
    private static final String ASSERTION_RESULT_TAG_NAME = "assertionResult";
    private static final String BINARY = "binary";
    private static final String DATA_TYPE = "dataType";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String FAILURE_MESSAGE = "failureMessage";
    private static final String LABEL = "label";
    private static final String RESPONSE_CODE = "responseCode";
    private static final String RESPONSE_MESSAGE = "responseMessage";
    private static final String SAMPLE_RESULT_TAG_NAME = "sampleResult";
    private static final String SUCCESSFUL = "success";
    private static final String THREAD_NAME = "threadName";
    private static final String TIME = "time";
    private static final String TIME_STAMP = "timeStamp";
    private static final DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();

    private OldSaveService() {
    }

    private static SampleResult getSampleResult(Configuration config) {
        SampleResult result = new SampleResult(config.getAttributeAsLong(TIME_STAMP, 0L), config.getAttributeAsLong(TIME, 0L));
        result.setThreadName(config.getAttribute(THREAD_NAME, ""));
        result.setDataType(config.getAttribute(DATA_TYPE, ""));
        result.setResponseCode(config.getAttribute(RESPONSE_CODE, ""));
        result.setResponseMessage(config.getAttribute(RESPONSE_MESSAGE, ""));
        result.setSuccessful(config.getAttributeAsBoolean(SUCCESSFUL, false));
        result.setSampleLabel(config.getAttribute(LABEL, ""));
        result.setResponseData(OldSaveService.getBinaryData(config.getChild(BINARY)));
        Configuration[] subResults = config.getChildren(SAMPLE_RESULT_TAG_NAME);
        for (int i = 0; i < subResults.length; ++i) {
            result.storeSubResult(OldSaveService.getSampleResult(subResults[i]));
        }
        Configuration[] assResults = config.getChildren(ASSERTION_RESULT_TAG_NAME);
        for (int i = 0; i < assResults.length; ++i) {
            result.addAssertionResult(OldSaveService.getAssertionResult(assResults[i]));
        }
        Configuration[] samplerData = config.getChildren("property");
        for (int i = 0; i < samplerData.length; ++i) {
            result.setSamplerData(samplerData[i].getValue(""));
        }
        return result;
    }

    private static byte[] getBinaryData(Configuration config) {
        if (config == null) {
            return new byte[0];
        }
        try {
            return config.getValue("").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    private static AssertionResult getAssertionResult(Configuration config) {
        AssertionResult result = new AssertionResult("");
        result.setError(config.getAttributeAsBoolean(ERROR, false));
        result.setFailure(config.getAttributeAsBoolean(FAILURE, false));
        result.setFailureMessage(config.getAttribute(FAILURE_MESSAGE, ""));
        return result;
    }

    public static synchronized HashTree loadSubTree(InputStream in) throws IOException {
        try {
            Configuration config = builder.build(in);
            HashTree loadedTree = OldSaveService.generateNode(config);
            return loadedTree;
        }
        catch (ConfigurationException e) {
            String message = "Problem loading using Avalon Configuration tools";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
        catch (SAXException e) {
            String message = "Problem with SAX implementation";
            log.error(message, (Throwable)e);
            throw new IOException(message);
        }
    }

    private static TestElement createTestElement(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        TestElement element = null;
        String testClass = config.getAttribute("class");
        String gui_class = "";
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals("property") || !children[i].getAttribute("name").equals("TestElement.gui_class")) continue;
            gui_class = children[i].getValue();
        }
        String newClass = NameUpdater.getCurrentTestName(testClass, gui_class);
        element = (TestElement)Class.forName(newClass).newInstance();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getName().equals("property")) {
                try {
                    JMeterProperty prop = OldSaveService.createProperty(children[i], newClass);
                    if (prop == null) continue;
                    element.setProperty(prop);
                }
                catch (Exception ex) {
                    log.error("Problem loading property", (Throwable)ex);
                    element.setProperty(children[i].getAttribute("name"), "");
                }
                continue;
            }
            if (children[i].getName().equals("testelement")) {
                element.setProperty(new TestElementProperty(children[i].getAttribute("name", ""), OldSaveService.createTestElement(children[i])));
                continue;
            }
            if (children[i].getName().equals("collection")) {
                element.setProperty(new CollectionProperty(children[i].getAttribute("name", ""), OldSaveService.createCollection(children[i], newClass)));
                continue;
            }
            if (!children[i].getName().equals("map")) continue;
            element.setProperty(new MapProperty(children[i].getAttribute("name", ""), OldSaveService.createMap(children[i], newClass)));
        }
        return element;
    }

    private static Collection<JMeterProperty> createCollection(Configuration config, String testClass) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Collection coll = (Collection)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        for (int i = 0; i < items.length; ++i) {
            JMeterProperty prop;
            if (items[i].getName().equals("property")) {
                prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                coll.add(prop);
                continue;
            }
            if (items[i].getName().equals("testelement")) {
                coll.add(new TestElementProperty(items[i].getAttribute("name", ""), OldSaveService.createTestElement(items[i])));
                continue;
            }
            if (items[i].getName().equals("collection")) {
                coll.add(new CollectionProperty(items[i].getAttribute("name", ""), OldSaveService.createCollection(items[i], testClass)));
                continue;
            }
            if (items[i].getName().equals("string")) {
                prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                coll.add(prop);
                continue;
            }
            if (!items[i].getName().equals("map")) continue;
            coll.add(new MapProperty(items[i].getAttribute("name", ""), OldSaveService.createMap(items[i], testClass)));
        }
        return coll;
    }

    private static JMeterProperty createProperty(Configuration config, String testClass) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        String name;
        String value = config.getValue("");
        String oname = name = config.getAttribute("name", value);
        String type = config.getAttribute("propType", StringProperty.class.getName());
        value = "TestElement.gui_class".equals(name = NameUpdater.getCurrentName(name, testClass)) ? NameUpdater.getCurrentName(value) : ("TestElement.test_class".equals(name) ? testClass : NameUpdater.getCurrentName(value, name, testClass));
        if (oname.length() != 0 && name.length() == 0) {
            return null;
        }
        JMeterProperty prop = (JMeterProperty)Class.forName(type).newInstance();
        prop.setName(name);
        prop.setObjectValue(value);
        return prop;
    }

    private static Map<String, JMeterProperty> createMap(Configuration config, String testClass) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Map map = (Map)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getName().equals("property")) {
                JMeterProperty prop = OldSaveService.createProperty(items[i], testClass);
                if (prop == null) continue;
                map.put(prop.getName(), prop);
                continue;
            }
            if (items[i].getName().equals("testelement")) {
                map.put(items[i].getAttribute("name", ""), new TestElementProperty(items[i].getAttribute("name", ""), OldSaveService.createTestElement(items[i])));
                continue;
            }
            if (items[i].getName().equals("collection")) {
                map.put(items[i].getAttribute("name"), new CollectionProperty(items[i].getAttribute("name", ""), OldSaveService.createCollection(items[i], testClass)));
                continue;
            }
            if (!items[i].getName().equals("map")) continue;
            map.put(items[i].getAttribute("name", ""), new MapProperty(items[i].getAttribute("name", ""), OldSaveService.createMap(items[i], testClass)));
        }
        return map;
    }

    private static HashTree generateNode(Configuration config) {
        TestElement element = null;
        try {
            element = OldSaveService.createTestElement(config.getChild("testelement"));
        }
        catch (Exception e) {
            log.error("Problem loading part of file", (Throwable)e);
            return null;
        }
        ListedHashTree subTree = new ListedHashTree((Object)element);
        Configuration[] subNodes = config.getChildren("node");
        for (int i = 0; i < subNodes.length; ++i) {
            HashTree t = OldSaveService.generateNode(subNodes[i]);
            if (t == null) continue;
            subTree.add((Object)element, t);
        }
        return subTree;
    }

    public static void processSamples(String filename, Visualizer visualizer, ResultCollector rc) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder cfgbuilder = new DefaultConfigurationBuilder();
        Configuration savedSamples = cfgbuilder.buildFromFile(filename);
        Configuration[] samples = savedSamples.getChildren();
        boolean errorsOnly = rc.isErrorLogging();
        boolean successOnly = rc.isSuccessOnlyLogging();
        for (int i = 0; i < samples.length; ++i) {
            SampleResult result = OldSaveService.getSampleResult(samples[i]);
            if (!ResultCollector.isSampleWanted(result.isSuccessful(), errorsOnly, successOnly)) continue;
            visualizer.add(result);
        }
    }
}

