/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestCompiler
implements HashTreeTraverser {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final String USE_STATIC_SET = "TestCompiler.useStaticSet";
    private static final boolean USE_STATIC_SET_DEFAULT = false;
    public static final boolean IS_USE_STATIC_SET = JMeterUtils.getPropDefault("TestCompiler.useStaticSet", false);
    private static final Set<ObjectPair> PAIRING = new HashSet<ObjectPair>();
    private final LinkedList<TestElement> stack = new LinkedList();
    private final Map<Sampler, SamplePackage> samplerConfigMap = new HashMap<Sampler, SamplePackage>();
    private final Map<TransactionController, SamplePackage> transactionControllerConfigMap = new HashMap<TransactionController, SamplePackage>();
    private final HashTree testTree;

    public TestCompiler(HashTree testTree) {
        this.testTree = testTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Set<ObjectPair> set = PAIRING;
        synchronized (set) {
            PAIRING.clear();
        }
    }

    public SamplePackage configureSampler(Sampler sampler) {
        SamplePackage pack = this.samplerConfigMap.get(sampler);
        pack.setSampler(sampler);
        this.configureWithConfigElements(sampler, pack.getConfigs());
        return pack;
    }

    public SamplePackage configureTransactionSampler(TransactionSampler transactionSampler) {
        TransactionController controller = transactionSampler.getTransactionController();
        SamplePackage pack = this.transactionControllerConfigMap.get(controller);
        pack.setSampler(transactionSampler);
        return pack;
    }

    public void done(SamplePackage pack) {
        pack.recoverRunningVersion();
    }

    public void addNode(Object node, HashTree subTree) {
        this.stack.addLast((TestElement)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtractNode() {
        LOG.debug("Subtracting node, stack size = " + this.stack.size());
        TestElement child = this.stack.getLast();
        this.trackIterationListeners(this.stack);
        if (child instanceof Sampler) {
            this.saveSamplerConfigs((Sampler)child);
        } else if (child instanceof TransactionController) {
            this.saveTransactionControllerConfigs((TransactionController)child);
        }
        this.stack.removeLast();
        if (this.stack.size() > 0) {
            TestElement parent = this.stack.getLast();
            boolean duplicate = false;
            if (parent instanceof Controller && (child instanceof Sampler || child instanceof Controller)) {
                if (!IS_USE_STATIC_SET && parent instanceof TestCompilerHelper) {
                    TestCompilerHelper te = (TestCompilerHelper)((Object)parent);
                    duplicate = !te.addTestElementOnce(child);
                } else {
                    ObjectPair pair = new ObjectPair(child, parent);
                    Set<ObjectPair> set = PAIRING;
                    synchronized (set) {
                        if (!PAIRING.contains(pair)) {
                            parent.addTestElement(child);
                            PAIRING.add(pair);
                        } else {
                            duplicate = true;
                        }
                    }
                }
            }
            if (duplicate) {
                LOG.warn("Unexpected duplicate for " + parent.getClass().getName() + " and " + child.getClass().getName());
            }
        }
    }

    private void trackIterationListeners(LinkedList<TestElement> p_stack) {
        TestElement child = p_stack.getLast();
        if (child instanceof LoopIterationListener) {
            ListIterator<TestElement> iter = p_stack.listIterator(p_stack.size());
            while (iter.hasPrevious()) {
                TestElement item = iter.previous();
                if (item == child || !(item instanceof Controller)) continue;
                TestBeanHelper.prepare(child);
                ((Controller)item).addIterationListener((LoopIterationListener)((Object)child));
                break;
            }
        }
    }

    public void processPath() {
    }

    private void saveSamplerConfigs(Sampler sam) {
        LinkedList<ConfigTestElement> configs = new LinkedList<ConfigTestElement>();
        LinkedList<Controller> controllers = new LinkedList<Controller>();
        LinkedList<SampleListener> listeners = new LinkedList<SampleListener>();
        LinkedList<Timer> timers = new LinkedList<Timer>();
        LinkedList<Assertion> assertions = new LinkedList<Assertion>();
        LinkedList<PostProcessor> posts = new LinkedList<PostProcessor>();
        LinkedList<PreProcessor> pres = new LinkedList<PreProcessor>();
        for (int i = this.stack.size(); i > 0; --i) {
            this.addDirectParentControllers(controllers, this.stack.get(i - 1));
            LinkedList<PreProcessor> tempPre = new LinkedList<PreProcessor>();
            LinkedList<PostProcessor> tempPost = new LinkedList<PostProcessor>();
            for (Object item : this.testTree.list(this.stack.subList(0, i))) {
                if (item instanceof ConfigTestElement) {
                    configs.add((ConfigTestElement)item);
                }
                if (item instanceof SampleListener) {
                    listeners.add((SampleListener)item);
                }
                if (item instanceof Timer) {
                    timers.add((Timer)item);
                }
                if (item instanceof Assertion) {
                    assertions.add((Assertion)item);
                }
                if (item instanceof PostProcessor) {
                    tempPost.add((PostProcessor)item);
                }
                if (!(item instanceof PreProcessor)) continue;
                tempPre.add((PreProcessor)item);
            }
            pres.addAll(0, tempPre);
            posts.addAll(0, tempPost);
        }
        SamplePackage pack = new SamplePackage(configs, listeners, timers, assertions, posts, pres, controllers);
        pack.setSampler(sam);
        pack.setRunningVersion(true);
        this.samplerConfigMap.put(sam, pack);
    }

    private void saveTransactionControllerConfigs(TransactionController tc) {
        LinkedList<ConfigTestElement> configs = new LinkedList<ConfigTestElement>();
        LinkedList<Controller> controllers = new LinkedList<Controller>();
        LinkedList<SampleListener> listeners = new LinkedList<SampleListener>();
        LinkedList<Timer> timers = new LinkedList<Timer>();
        LinkedList<Assertion> assertions = new LinkedList<Assertion>();
        LinkedList<PostProcessor> posts = new LinkedList<PostProcessor>();
        LinkedList<PreProcessor> pres = new LinkedList<PreProcessor>();
        for (int i = this.stack.size(); i > 0; --i) {
            this.addDirectParentControllers(controllers, this.stack.get(i - 1));
            for (Object item : this.testTree.list(this.stack.subList(0, i))) {
                if (item instanceof SampleListener) {
                    listeners.add((SampleListener)item);
                }
                if (!(item instanceof Assertion)) continue;
                assertions.add((Assertion)item);
            }
        }
        SamplePackage pack = new SamplePackage(configs, listeners, timers, assertions, posts, pres, controllers);
        pack.setSampler(new TransactionSampler(tc, tc.getName()));
        pack.setRunningVersion(true);
        this.transactionControllerConfigMap.put(tc, pack);
    }

    private void addDirectParentControllers(List<Controller> controllers, TestElement maybeController) {
        if (maybeController instanceof Controller) {
            LOG.debug("adding controller: " + maybeController + " to sampler config");
            controllers.add((Controller)maybeController);
        }
    }

    private void configureWithConfigElements(Sampler sam, List<ConfigTestElement> configs) {
        sam.clearTestElementChildren();
        for (ConfigTestElement config : configs) {
            if (config instanceof NoConfigMerge) continue;
            if (sam instanceof ConfigMergabilityIndicator) {
                if (!((ConfigMergabilityIndicator)((Object)sam)).applies(config)) continue;
                sam.addTestElement(config);
                continue;
            }
            sam.addTestElement(config);
        }
    }

    private static class ObjectPair {
        private final TestElement child;
        private final TestElement parent;

        public ObjectPair(TestElement child, TestElement parent) {
            this.child = child;
            this.parent = parent;
        }

        public int hashCode() {
            return this.child.hashCode() + this.parent.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ObjectPair) {
                return this.child == ((ObjectPair)o).child && this.parent == ((ObjectPair)o).parent;
            }
            return false;
        }
    }
}

