/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class Document {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int MAX_DOCUMENT_SIZE = JMeterUtils.getPropDefault("document.max_size", 0xA00000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextFromDocument(byte[] document) {
        String errMissingTika;
        String response = errMissingTika = JMeterUtils.getResString("view_results_response_missing_tika");
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler(MAX_DOCUMENT_SIZE > 0 ? MAX_DOCUMENT_SIZE : -1);
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        ByteArrayInputStream stream = new ByteArrayInputStream(document);
        try {
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
            response = handler.toString();
        }
        catch (Exception e) {
            response = e.toString();
            log.warn("Error document parsing:", (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            if (!System.getProperty("java.class.path").contains("tika-app")) {
                log.warn(errMissingTika);
            } else {
                log.warn(errMissingTika, (Throwable)e);
            }
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException ioe) {
                log.warn("Error closing document stream", (Throwable)ioe);
            }
        }
        if (response.length() == 0 && document.length > 0) {
            log.warn("Probably: " + errMissingTika);
            response = errMissingTika;
        }
        return response;
    }
}

