/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.blame;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;

public class SvnJavaBlameCommand
extends AbstractBlameCommand
implements SvnCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        try {
            SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
            javaRepo.getClientManager();
            AnnotationHandler handler = new AnnotationHandler();
            SvnJavaUtil.blame(javaRepo.getClientManager(), new File(workingDirectory.getBasedir(), filename), handler);
            return new BlameScmResult("", handler.lines);
        }
        catch (SVNException e) {
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
    }

    private static class AnnotationHandler
    implements ISVNAnnotateHandler {
        private List<BlameLine> lines = new ArrayList<BlameLine>();

        private AnnotationHandler() {
        }

        public void handleEOF() {
        }

        public void handleLine(Date arg0, long arg1, String arg2, String arg3) throws SVNException {
        }

        public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
            BlameLine blameLine = new BlameLine(date, Long.toString(revision), author);
            if (this.lines.size() > lineNumber) {
                this.lines.set(lineNumber, blameLine);
            } else {
                this.lines.add(blameLine);
            }
        }

        public boolean handleRevision(Date arg0, long arg1, String arg2, File arg3) throws SVNException {
            return true;
        }
    }
}

