/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.mkdir;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.mkdir.AbstractMkdirCommand;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnJavaMkdirCommand
extends AbstractMkdirCommand
implements SvnCommand {
    protected MkdirScmResult executeMkdirCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean createInLocal) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        Iterator it = fileSet.getFileList().iterator();
        String dirPath = ((File)it.next()).getPath();
        if (dirPath != null && Os.isFamily((String)"dos")) {
            dirPath = StringUtils.replace((String)dirPath, (String)"\\", (String)"/");
        }
        String url = javaRepo.getUrl() + "/" + dirPath;
        if (createInLocal) {
            url = dirPath;
        }
        ArrayList<SVNURL> svnurls = new ArrayList<SVNURL>(1);
        try {
            svnurls.add(SVNURL.parseURIEncoded((String)url));
            SVNCommitInfo commitInfo = SvnJavaUtil.mkdir(javaRepo.getClientManager(), svnurls.toArray(new SVNURL[svnurls.size()]), message);
            ScmResult scmResult = new ScmResult(null, null, null, true);
            return new MkdirScmResult(Long.toString(commitInfo.getNewRevision()), scmResult);
        }
        catch (SVNException e) {
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
    }
}

