/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrs;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsWinrsConnection
extends CifsConnection {
    private ConnectionOptions options;
    private OverthereConnection winrsProxyConnection;
    private static final Logger logger = LoggerFactory.getLogger(CifsWinrsConnection.class);

    public CifsWinrsConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        OverthereUtils.checkArgument(this.os == OperatingSystemFamily.WINDOWS, "Cannot create a cifs:%s connection to a machine that is not running Windows", this.cifsConnectionType.toString().toLowerCase());
        OverthereUtils.checkArgument(mapper instanceof DefaultAddressPortMapper, "Cannot create a cifs:%s connection when connecting through a SSH jumpstation", this.cifsConnectionType.toString().toLowerCase());
        OverthereUtils.checkArgument(this.password.indexOf(39) == -1 && this.password.indexOf(34) == -1, "Cannot create a cifs:%s connection with a password that contains a single quote (') or a double quote (\")", this.cifsConnectionType.toString().toLowerCase());
        this.options = options;
        this.connectToWinrsProxy(options);
        if (this.winrsProxyConnection.getHostOperatingSystem() != OperatingSystemFamily.WINDOWS) {
            this.disconnectFromWinrsProxy();
            throw new IllegalArgumentException(String.format("Cannot create a cifs:%s connection with a winrs proxy that is not running Windows", this.cifsConnectionType.toString().toLowerCase()));
        }
        this.connected();
    }

    @Override
    public void doClose() {
        this.disconnectFromWinrsProxy();
    }

    private void connectToWinrsProxy(ConnectionOptions options) {
        logger.debug("Connecting to winrs proxy");
        String winrsProxyProtocol = options.get("winrsProxyProtocol", "local");
        ConnectionOptions winrsProxyConnectionOptions = options.get("winrsProxyConnectionOptions", new ConnectionOptions());
        this.winrsProxyConnection = Overthere.getConnection(winrsProxyProtocol, winrsProxyConnectionOptions);
    }

    private void disconnectFromWinrsProxy() {
        logger.debug("Disconnecting from winrs proxy");
        OverthereUtils.closeQuietly(this.winrsProxyConnection);
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        OverthereUtils.checkNotNull(cmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(cmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        CmdLine winrsCmd = new CmdLine();
        winrsCmd.addArgument("winrs");
        winrsCmd.addArgument("-remote:" + this.address + ":" + this.port);
        winrsCmd.addArgument("-username:" + this.username);
        winrsCmd.addPassword("-password:" + this.password);
        if (this.workingDirectory != null) {
            winrsCmd.addArgument("-directory:" + this.workingDirectory.getPath());
        }
        if (this.options.getBoolean("winrsNoecho", false)) {
            winrsCmd.addArgument("-noecho");
        }
        if (this.options.getBoolean("winrsNoprofile", false)) {
            winrsCmd.addArgument("-noprofile");
        }
        if (this.options.getBoolean("winrsAllowDelegate", false)) {
            winrsCmd.addArgument("-allowdelegate");
        }
        if (this.options.getBoolean("winrsCompression", false)) {
            winrsCmd.addArgument("-compression");
        }
        if (this.options.getBoolean("winrsUnencrypted", false)) {
            winrsCmd.addArgument("-unencrypted");
        }
        if (this.options.getBoolean("winrmEnableHttps", false)) {
            winrsCmd.addArgument("-usessl");
        }
        winrsCmd.add(cmd.getArguments());
        return this.winrsProxyConnection.startProcess(winrsCmd);
    }
}

