/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshElevatedUserConnection;
import com.xebialabs.overthere.ssh.SshElevatedUserOutputStream;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshScpFile;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereExecutionOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshElevatedUserFile
extends SshScpFile {
    private static Logger logger = LoggerFactory.getLogger(SshElevatedUserFile.class);
    private boolean isTempFile;

    public SshElevatedUserFile(SshElevatedUserConnection connection, String remotePath, boolean isTempFile) {
        super(connection, remotePath);
        this.isTempFile = isTempFile;
    }

    @Override
    protected int executeCommand(OverthereExecutionOutputHandler outHandler, OverthereExecutionOutputHandler errHandler, CmdLine commandLine) {
        if (this.isTempFile) {
            commandLine = SshConnection.prefixWithPseudoCommand(commandLine, "nosudo");
        }
        return super.executeCommand(outHandler, errHandler, commandLine);
    }

    @Override
    public OverthereFile getFile(String name) {
        SshElevatedUserFile f = (SshElevatedUserFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public OverthereFile getParentFile() {
        SshElevatedUserFile f = (SshElevatedUserFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getInputStream();
        }
        OverthereFile tempFile = ((SshScpConnection)this.connection).getTempFile(this.getName());
        this.copyToTempFile(tempFile);
        return tempFile.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getOutputStream();
        }
        logger.debug("Opening ssh:{}: output stream to write to file {}", (Object)((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase(), (Object)this);
        return new SshElevatedUserOutputStream(this, ((SshScpConnection)this.connection).getTempFile(this.getName()));
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (this.isTempFile) {
            logger.debug("Creating world-writable directory, with sticky bit (mode 01777)");
            this.mkdir(((SshElevatedUserConnection)this.connection).tempMkdirCommand);
        } else {
            super.mkdir();
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.isTempFile) {
            logger.debug("Creating world-writable directories, with sticky bit (mode 01777)");
            this.mkdir(((SshElevatedUserConnection)this.connection).tempMkdirsCommand);
        } else {
            super.mkdirs();
        }
    }

    @Override
    protected void copyFrom(OverthereFile source) {
        if (this.isTempFile) {
            super.copyFrom(source);
            this.overrideUmask(this);
        } else {
            logger.debug("Copying file or directory {} to {}", (Object)source, (Object)this);
            OverthereFile tempFile = ((SshScpConnection)this.getConnection()).getTempFile(this.getName());
            try {
                ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient().copy((LocalSourceFile)new SshScpFile.OverthereFileLocalSourceFile(source), tempFile.getPath());
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot copy " + source + " to " + this, e);
            }
            this.overrideUmask(tempFile);
            this.copyFromTempFile(tempFile);
        }
    }

    private void overrideUmask(OverthereFile remoteFile) {
        if (((SshElevatedUserConnection)this.connection).overrideUmask) {
            logger.debug("Overriding umask by recursively setting permissions on files and/or directories copied with scp to be readable and executable (if needed) by group and other");
            CmdLine chmodCmdLine = CmdLine.build("nosudo", "nocd").addTemplatedFragment(((SshElevatedUserConnection)this.connection).overrideUmaskCommand, remoteFile.getPath());
            CapturingOverthereExecutionOutputHandler capturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
            int errno = ((SshScpConnection)this.connection).execute(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), capturedOutput), chmodCmdLine);
            if (errno != 0) {
                throw new RuntimeIOException("Cannot set permissions on file " + this + " to go+rX: " + capturedOutput.getOutput() + " (errno=" + errno + ")");
            }
        }
    }

    void copyToTempFile(OverthereFile tempFile) {
        logger.debug("Copying actual file {} to temporary file {} before download", (Object)this, (Object)tempFile);
        CmdLine cpCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshElevatedUserConnection)this.connection).copyToTempFileCommand, this.getPath(), tempFile.getPath());
        CapturingOverthereExecutionOutputHandler cpCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), cpCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), cpCapturedOutput), cpCmdLine);
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot copy actual file " + this + " to temporary file " + tempFile + " before download: " + errorMessage);
        }
        CmdLine chmodCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshElevatedUserConnection)this.connection).overrideUmaskCommand, tempFile.getPath());
        CapturingOverthereExecutionOutputHandler chmodCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int chmodResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), chmodCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), chmodCapturedOutput), chmodCmdLine);
        if (chmodResult != 0) {
            String errorMessage = chmodCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot grant group and other read and execute permissions (chmod -R go+rX) to file " + tempFile + " before download: " + errorMessage);
        }
    }

    void copyFromTempFile(OverthereFile tempFile) {
        logger.debug("Copying temporary file {} to actual file {} after upload", (Object)tempFile, (Object)this);
        String targetPath = this.getPath();
        if (this.exists() && tempFile.isDirectory()) {
            targetPath = this.getParentFile().getPath();
        }
        CmdLine cpCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshElevatedUserConnection)this.connection).copyFromTempFileCommand, tempFile.getPath(), targetPath);
        CapturingOverthereExecutionOutputHandler cpCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), cpCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), cpCapturedOutput), cpCmdLine);
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot copy temporary file " + tempFile + " to actual file " + this + " after upload: " + errorMessage);
        }
    }

    boolean isTempFile() {
        return this.isTempFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SshElevatedUserFile)) {
            return false;
        }
        return super.equals(obj) && this.isTempFile == ((SshElevatedUserFile)obj).isTempFile;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.valueOf(this.isTempFile).hashCode();
    }
}

